/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

public enum Icmp6Type {
    DEST_UNREACH(1),
    PKT_TOO_BIG(2),
    TIME_EXCEED(3),
    PARAM_ERR(4),
    ECHO_REQUEST(-128),
    ECHO_REPLY(-127),
    MCAST_QUERY(-126),
    MCAST_REPORT(-125),
    MCAST_DONE(-124),
    ROUTER_SOLICITATION(-123),
    ROUTER_ADVERTISEMENT(-122),
    NEIGHBOR_SOLICITATION(-121),
    NEIGHBOR_ADVERTISEMENT(-120),
    REDIRECT(-119);

    private byte value;

    private Icmp6Type(byte value) {
        this.value = value;
    }

    public byte value() {
        return this.value;
    }

    public static byte parseFromString(String input) {
        try {
            return Icmp6Type.valueOf(input).value();
        }
        catch (IllegalArgumentException e) {
            try {
                return Byte.parseByte(input);
            }
            catch (NumberFormatException e1) {
                throw new IllegalArgumentException("Icmp6Type value must be either a string type name or an 8-bit type value");
            }
        }
    }
}

