/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.resource.label.LabelResourcePool;
import org.onosproject.incubator.net.resource.label.LabelResourceService;
import org.onosproject.net.DeviceId;

@Command(scope="onos", name="label-pool", description="Gets label resource pool information by a specific device id")
public class LabelResourceCommand
extends AbstractShellCommand {
    @Argument(index=0, name="deviceId", description="Device identity", required=true, multiValued=false)
    String deviceId = null;
    private static final String FMT = "deviceid=%s, beginLabel=%s,endLabel=%s, totalNum=%s, usedNum=%s, currentUsedMaxLabelId=%s,releaseLabelIds=%s";

    @Override
    protected void execute() {
        LabelResourceService lrs = LabelResourceCommand.get(LabelResourceService.class);
        LabelResourcePool pool = lrs.getDeviceLabelResourcePool(DeviceId.deviceId((String)this.deviceId));
        if (pool != null) {
            this.print(FMT, pool.deviceId().toString(), pool.beginLabel(), pool.endLabel(), pool.totalNum(), pool.usedNum(), pool.currentUsedMaxLabelId(), pool.releaseLabelId().toString());
        } else {
            this.print(FMT, this.deviceId, null, null, null, null, null, null);
        }
    }
}

