/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.Set;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.mcast.McastRoute;
import org.onosproject.net.mcast.MulticastRouteService;

@Command(scope="onos", name="mcast-show", description="Displays the source, multicast group flows")
public class McastShowCommand
extends AbstractShellCommand {
    private static final String FORMAT = "route=%s, source=%s, sinks=%s";

    @Override
    protected void execute() {
        MulticastRouteService mcastService = McastShowCommand.get(MulticastRouteService.class);
        Set routes = mcastService.getRoutes();
        for (McastRoute route : routes) {
            Set sinks = mcastService.fetchSinks(route);
            ConnectPoint source = mcastService.fetchSource(route);
            this.print(FORMAT, route, source, sinks);
        }
    }
}

