/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.InterfaceConfig;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;

@Command(scope="onos", name="device-remove-interface", description="Removes an interface configuration from a device")
public class DeviceInterfaceRemoveCommand
extends AbstractShellCommand {
    private static final String ONE_ACTION_ALLOWED = "One configuration removal allowed at a time";
    private static final String REMOVE_ACCESS_SUCCESS = "Access mode removed from device %s interface %s.";
    private static final String REMOVE_ACCESS_FAILURE = "Failed to remove access mode from device %s interface %s.";
    private static final String REMOVE_TRUNK_SUCCESS = "Trunk mode removed from device %s interface %s.";
    private static final String REMOVE_TRUNK_FAILURE = "Failed to remove trunk mode from device %s interface %s.";
    private static final String REMOVE_RATE_SUCCESS = "Rate limit removed from device %s interface %s.";
    private static final String REMOVE_RATE_FAILURE = "Failed to remove rate limit from device %s interface %s.";
    @Argument(index=0, name="uri", description="Device ID", required=true, multiValued=false)
    private String uri = null;
    @Argument(index=1, name="interface", description="Interface name", required=true, multiValued=false)
    private String portName = null;
    @Option(name="-r", aliases={"--rate-limit"}, description="Percentage for egress bandwidth limit", required=false, multiValued=false)
    private boolean rateLimit = false;
    @Option(name="-t", aliases={"--trunk"}, description="Remove trunk mode for VLAN(s)", required=false, multiValued=false)
    private boolean trunkMode = false;
    @Option(name="-a", aliases={"--access"}, description="Remove access mode for VLAN", required=false, multiValued=false)
    private boolean accessMode = false;

    @Override
    protected void execute() {
        DriverService service = DeviceInterfaceRemoveCommand.get(DriverService.class);
        DeviceId deviceId = DeviceId.deviceId((String)this.uri);
        DriverHandler h = service.createHandler(deviceId, new String[0]);
        InterfaceConfig interfaceConfig = (InterfaceConfig)h.behaviour(InterfaceConfig.class);
        if (this.trunkMode && !this.accessMode && !this.rateLimit) {
            this.removeTrunkModeFromIntf(interfaceConfig);
        } else if (this.accessMode && !this.trunkMode && !this.rateLimit) {
            this.removeAccessModeFromIntf(interfaceConfig);
        } else if (this.rateLimit && !this.trunkMode && !this.accessMode) {
            this.removeRateLimitFromIntf(interfaceConfig);
        } else {
            this.print(ONE_ACTION_ALLOWED, new Object[0]);
        }
    }

    private void removeAccessModeFromIntf(InterfaceConfig interfaceConfig) {
        if (interfaceConfig.removeAccessMode(this.portName)) {
            this.print(REMOVE_ACCESS_SUCCESS, this.uri, this.portName);
        } else {
            this.print(REMOVE_ACCESS_FAILURE, this.uri, this.portName);
        }
    }

    private void removeTrunkModeFromIntf(InterfaceConfig interfaceConfig) {
        if (interfaceConfig.removeTrunkMode(this.portName)) {
            this.print(REMOVE_TRUNK_SUCCESS, this.uri, this.portName);
        } else {
            this.print(REMOVE_TRUNK_FAILURE, this.uri, this.portName);
        }
    }

    private void removeRateLimitFromIntf(InterfaceConfig config) {
        if (config.removeRateLimit(this.portName)) {
            this.print(REMOVE_RATE_SUCCESS, this.uri, this.portName);
        } else {
            this.print(REMOVE_RATE_FAILURE, this.uri, this.portName);
        }
    }
}

