/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net.vnet;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkAdminService;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.incubator.net.virtual.VirtualPort;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;

@Command(scope="onos", name="vnet-port-state", description="Administratively enables or disables state of an existing virtual port.")
public class VirtualPortStateCommand
extends AbstractShellCommand {
    @Argument(index=0, name="networkId", description="Network ID", required=true, multiValued=false)
    Long networkId = null;
    @Argument(index=1, name="deviceId", description="Virtual Device ID", required=true, multiValued=false)
    String deviceId = null;
    @Argument(index=2, name="portNum", description="Virtual device port number", required=true, multiValued=false)
    Integer portNum = null;
    @Argument(index=3, name="portState", description="Desired State. Either \"enable\" or \"disable\".", required=true, multiValued=false)
    String portState = null;

    @Override
    protected void execute() {
        boolean isEnabled;
        VirtualNetworkAdminService service = VirtualPortStateCommand.get(VirtualNetworkAdminService.class);
        VirtualPort vPort = this.getVirtualPort(PortNumber.portNumber((long)this.portNum.intValue()));
        Preconditions.checkNotNull((Object)vPort, (Object)"The virtual Port does not exist");
        if ("enable".equals(this.portState)) {
            isEnabled = true;
        } else if ("disable".equals(this.portState)) {
            isEnabled = false;
        } else {
            this.print("State must be enable or disable", new Object[0]);
            return;
        }
        service.updatePortState(NetworkId.networkId((long)this.networkId), DeviceId.deviceId((String)this.deviceId), vPort.number(), isEnabled);
        this.print("Virtual port state updated.", new Object[0]);
    }

    private VirtualPort getVirtualPort(PortNumber aPortNumber) {
        VirtualNetworkService service = VirtualPortStateCommand.get(VirtualNetworkService.class);
        Set ports = service.getVirtualPorts(NetworkId.networkId((long)this.networkId), DeviceId.deviceId((String)this.deviceId));
        return ports.stream().filter(p -> p.number().equals((Object)aPortNumber)).findFirst().get();
    }
}

