/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.resource.label.DefaultLabelResource;
import org.onosproject.incubator.net.resource.label.LabelResourceId;
import org.onosproject.incubator.net.resource.label.LabelResourceService;
import org.onosproject.net.DeviceId;

@Command(scope="onos", name="label-release", description="Releases label ids to label resource pool by a specific device id")
public class LabelReleaseCommand
extends AbstractShellCommand {
    @Argument(index=0, name="deviceId", description="Device identity", required=true, multiValued=false)
    String deviceId = null;
    @Argument(index=1, name="releaseLabelIds", description="Represents for the label ids that are released. They are splited by dot symbol", required=true, multiValued=false)
    String releaseLabelIds = null;

    @Override
    protected void execute() {
        LabelResourceService lrs = LabelReleaseCommand.get(LabelResourceService.class);
        ArrayListMultimap map = ArrayListMultimap.create();
        String[] labelIds = this.releaseLabelIds.split(",");
        DefaultLabelResource resource = null;
        for (int i = 0; i < labelIds.length; ++i) {
            resource = new DefaultLabelResource(DeviceId.deviceId((String)this.deviceId), LabelResourceId.labelResourceId((long)Long.parseLong(labelIds[i])));
            map.put((Object)DeviceId.deviceId((String)this.deviceId), (Object)resource);
        }
        lrs.releaseToDevicePool((Multimap)map);
    }
}

