/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.ArrayList;
import java.util.Optional;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.packet.VlanId;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.protection.ProtectedTransportEndpointDescription;
import org.onosproject.net.behaviour.protection.TransportEndpointDescription;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.ProtectionEndpointIntent;

@Command(scope="onos", name="test-add-protection-endpoint", description="Test tool to add ProtectionEndpointIntent")
public class TestProtectionEndpointIntentCommand
extends AbstractShellCommand {
    private static final String DEFAULT_FINGERPRINT = "[fingerprint]";
    @Option(name="--fingerprint", description="Fingerprint to identify the protected transport entity", valueToShowInHelp="[fingerprint]")
    private String fingerprint = "[fingerprint]";
    @Argument(index=0, name="deviceId", description="Device ID to configure", required=true)
    private String deviceIdStr = null;
    @Argument(index=1, name="peerDeviceId", description="Device ID of remote peer", required=true)
    private String peerStr = null;
    @Argument(index=2, name="portNumber1", description="PortNumber leading to working path on deviceId", required=true)
    private String portNumber1Str = null;
    @Argument(index=3, name="portNumber2", description="PortNumber leading to standby path on deviceId", required=true)
    private String portNumber2Str = null;
    @Option(name="--vlan1", description="VLAN ID to push on portNumber1 expressed in decimal")
    private String vlan1Str = null;
    @Option(name="--vlan2", description="VLAN ID to push on portNumber2 expressed in decimal")
    private String vlan2Str = null;
    private IntentService intentService;
    private DeviceService deviceService;

    @Override
    protected void execute() {
        this.fingerprint = Optional.ofNullable(this.fingerprint).orElse(DEFAULT_FINGERPRINT);
        this.intentService = TestProtectionEndpointIntentCommand.get(IntentService.class);
        this.deviceService = TestProtectionEndpointIntentCommand.get(DeviceService.class);
        DeviceId did = DeviceId.deviceId((String)this.deviceIdStr);
        DeviceId peer = DeviceId.deviceId((String)this.peerStr);
        ArrayList<TransportEndpointDescription> paths = new ArrayList<TransportEndpointDescription>();
        paths.add(TransportEndpointDescription.builder().withOutput(this.output(did, this.portNumber1Str, this.vlan1Str)).build());
        paths.add(TransportEndpointDescription.builder().withOutput(this.output(did, this.portNumber2Str, this.vlan2Str)).build());
        ProtectedTransportEndpointDescription description = ProtectedTransportEndpointDescription.of(paths, (DeviceId)peer, (String)this.fingerprint);
        ProtectionEndpointIntent intent = ProtectionEndpointIntent.builder().key(Key.of((String)this.fingerprint, (ApplicationId)this.appId())).appId(this.appId()).deviceId(did).description(description).build();
        this.print("Submitting: %s", intent);
        this.intentService.submit((Intent)intent);
    }

    private FilteredConnectPoint output(DeviceId did, String portNumberStr, String vlanStr) {
        ConnectPoint cp = new ConnectPoint((ElementId)did, PortNumber.fromString((String)portNumberStr));
        if (this.deviceService.getPort(cp) == null) {
            this.print("Unknown port: %s", cp);
        }
        if (vlanStr == null) {
            return new FilteredConnectPoint(cp);
        }
        VlanId vlan = VlanId.vlanId((String)vlanStr);
        TrafficSelector sel = DefaultTrafficSelector.builder().matchVlanId(vlan).build();
        return new FilteredConnectPoint(cp, sel);
    }
}

