/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.packet.IpAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.tunnel.DefaultOpticalTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.IpTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.OpticalLogicId;
import org.onosproject.incubator.net.tunnel.OpticalTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelEndPoint;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.tunnel.TunnelService;
import org.onosproject.net.Annotations;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.provider.ProviderId;

@Command(scope="onos", name="tunnels", description="Supports for querying tunnels. It's used by consumers.")
public class TunnelQueryCommand
extends AbstractShellCommand {
    @Option(name="-s", aliases={"--src"}, description="Source tunnel point. Only supports for IpTunnelEndPoint and OpticalTunnelEndPoint as end point now. If deletess a ODUK or OCH type tunnel, the formatter of this argument is DeviceId-PortNumber. Otherwise src means IP address.", required=false, multiValued=false)
    String src = null;
    @Option(name="-d", aliases={"--dst"}, description="Destination tunnel point. Only supports for IpTunnelEndPoint and OpticalTunnelEndPoint as end point now. If deletess a ODUK or OCH type tunnel, the formatter of this argument is DeviceId-PortNumber. Otherwise dst means IP address.", required=false, multiValued=false)
    String dst = null;
    @Option(name="-t", aliases={"--type"}, description="The type of tunnels, It includes MPLS, VLAN, VXLAN, GRE, ODUK, OCH", required=false, multiValued=false)
    String type = null;
    @Option(name="-i", aliases={"--tunnelId"}, description="the tunnel identity.", required=false, multiValued=false)
    String tunnelId = null;
    private static final String FMT = "tunnelId=%s, src=%s, dst=%s,type=%s, state=%s, producerName=%s, tunnelName=%s,groupId=%s, path=%s%s";

    @Override
    protected void execute() {
        Tunnel.Type trueType = null;
        TunnelService service = TunnelQueryCommand.get(TunnelService.class);
        ProviderId producerName = new ProviderId("default", "org.onosproject.provider.tunnel.default");
        Collection<Object> tunnelSet = null;
        if (this.isNull(this.src) && this.isNull(this.dst) && this.isNull(this.type) && this.isNull(this.tunnelId)) {
            tunnelSet = service.queryAllTunnels();
        }
        if (!(this.isNull(this.src) || this.isNull(this.dst) || this.isNull(this.type))) {
            String[] dstArray;
            String[] srcArray;
            IpTunnelEndPoint srcPoint = null;
            IpTunnelEndPoint dstPoint = null;
            if ("MPLS".equals(this.type) || "VXLAN".equals(this.type) || "GRE".equals(this.type)) {
                srcPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)this.src));
                dstPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)this.dst));
            } else if ("VLAN".equals(this.type)) {
                srcArray = this.src.split("/");
                dstArray = this.dst.split("/");
                srcPoint = new DefaultOpticalTunnelEndPoint(producerName, Optional.of(DeviceId.deviceId((String)srcArray[0])), Optional.of(PortNumber.portNumber((String)srcArray[1])), null, null, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
                dstPoint = new DefaultOpticalTunnelEndPoint(producerName, Optional.of(DeviceId.deviceId((String)dstArray[0])), Optional.of(PortNumber.portNumber((String)dstArray[1])), null, null, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
            } else if ("ODUK".equals(this.type)) {
                srcArray = this.src.split("/");
                dstArray = this.dst.split("/");
                srcPoint = new DefaultOpticalTunnelEndPoint(producerName, Optional.of(DeviceId.deviceId((String)srcArray[0])), Optional.of(PortNumber.portNumber((String)srcArray[1])), null, OpticalTunnelEndPoint.Type.LAMBDA, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
                dstPoint = new DefaultOpticalTunnelEndPoint(producerName, Optional.of(DeviceId.deviceId((String)dstArray[0])), Optional.of(PortNumber.portNumber((String)dstArray[1])), null, OpticalTunnelEndPoint.Type.LAMBDA, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
            } else if ("OCH".equals(this.type)) {
                srcArray = this.src.split("/");
                dstArray = this.dst.split("/");
                srcPoint = new DefaultOpticalTunnelEndPoint(producerName, Optional.of(DeviceId.deviceId((String)srcArray[0])), Optional.of(PortNumber.portNumber((String)srcArray[1])), null, OpticalTunnelEndPoint.Type.TIMESLOT, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
                dstPoint = new DefaultOpticalTunnelEndPoint(producerName, Optional.of(DeviceId.deviceId((String)dstArray[0])), Optional.of(PortNumber.portNumber((String)dstArray[1])), null, OpticalTunnelEndPoint.Type.TIMESLOT, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
            } else {
                this.print("Illegal tunnel type. Please input MPLS, VLAN, VXLAN, GRE, ODUK or OCH.", new Object[0]);
                return;
            }
            tunnelSet = service.queryTunnel((TunnelEndPoint)srcPoint, (TunnelEndPoint)dstPoint);
        }
        if (!this.isNull(this.type)) {
            if ("MPLS".equals(this.type)) {
                trueType = Tunnel.Type.MPLS;
            } else if ("VLAN".equals(this.type)) {
                trueType = Tunnel.Type.VLAN;
            } else if ("VXLAN".equals(this.type)) {
                trueType = Tunnel.Type.VXLAN;
            } else if ("GRE".equals(this.type)) {
                trueType = Tunnel.Type.GRE;
            } else if ("ODUK".equals(this.type)) {
                trueType = Tunnel.Type.ODUK;
            } else if ("OCH".equals(this.type)) {
                trueType = Tunnel.Type.OCH;
            } else {
                this.print("Illegal tunnel type. Please input MPLS, VLAN, VXLAN, GRE, ODUK or OCH.", new Object[0]);
                return;
            }
            tunnelSet = service.queryTunnel(trueType);
        }
        if (!this.isNull(this.tunnelId)) {
            TunnelId id = TunnelId.valueOf((String)this.tunnelId);
            Tunnel tunnel = service.queryTunnel(id);
            tunnelSet = new HashSet<Tunnel>();
            tunnelSet.add(tunnel);
        }
        if (tunnelSet != null) {
            for (Tunnel tunnel : tunnelSet) {
                this.print(FMT, tunnel.tunnelId().id(), tunnel.src().toString(), tunnel.dst().toString(), tunnel.type(), tunnel.state(), tunnel.providerId(), tunnel.tunnelName(), tunnel.groupId(), this.showPath(tunnel.path()), TunnelQueryCommand.annotations(tunnel.annotations()));
            }
        }
    }

    private String showPath(Path path) {
        if (path == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder("(");
        for (Link link : path.links()) {
            builder.append("(DeviceId:" + link.src().deviceId() + " Port:" + link.src().port().toString());
            builder.append(" DeviceId:" + link.dst().deviceId() + " Port:" + link.dst().port().toString() + ")");
        }
        builder.append(TunnelQueryCommand.annotations(path.annotations()) + ")");
        return builder.toString();
    }

    private boolean isNull(String s) {
        return s == null || "".equals(s);
    }
}

