/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.dpi.DpiStatInfo;
import org.onosproject.incubator.net.dpi.DpiStatistics;
import org.onosproject.incubator.net.dpi.DpiStatisticsManagerService;
import org.onosproject.incubator.net.dpi.FlowStatInfo;
import org.onosproject.incubator.net.dpi.ProtocolStatInfo;
import org.onosproject.incubator.net.dpi.TrafficStatInfo;

@Command(scope="onos", name="dpis", description="Fetches the DPI result entries that is received from DPI engine server")
public class DpisListCommand
extends AbstractShellCommand {
    @Argument(index=0, name="receivedTime", description="received time: format 'yyyy-MM-dd HH:mm:ss', ex:'2016-08-30 10:31:20', default = null(latest time)", required=false, multiValued=false)
    String receivedTime = null;
    @Option(name="-l", aliases={"--latest"}, description="Show the latest dpi stats result entry", required=false, multiValued=false)
    boolean latest = true;
    @Option(name="-d", aliases={"--detectedProtocols"}, description="Show the detected protocols only for each statistic entry", required=false, multiValued=false)
    boolean dProtocols = false;
    @Option(name="-k", aliases={"--knownFlows"}, description="Show the known flows only for each statistic entry", required=false, multiValued=false)
    boolean kFlows = false;
    @Option(name="-u", aliases={"--unknownFlows"}, description="Show the unknown flows only for each statistic entry", required=false, multiValued=false)
    boolean uFlows = false;
    @Option(name="-a", aliases={"--all"}, description="Show the all statistics information in detail for each statistic entry", required=false, multiValued=false)
    boolean all = false;
    @Option(name="-p", aliases={"--permanent"}, description="Show the latest dpi stats result entry permanently at 5 second, use Ctrl+C for quitting", required=false, multiValued=false)
    boolean permanent = false;
    @Option(name="-n", aliases={"--lastn"}, description="Show the last N Dpi stats result entries, MAX_REQUEST_ENTRY = 100", required=false, multiValued=false)
    String lastn = null;
    @Option(name="-P", aliases={"--topnProtocols"}, description="Show the topn detected Protocol result entries, MAX_PROTOCOLS_TOPN = 100", required=false, multiValued=false)
    String topnProtocols = null;
    @Option(name="-F", aliases={"--topnFlows"}, description="Show the topn known and unknown Flows result entries, MAX_FLOWS_TOPN = 100", required=false, multiValued=false)
    String topnFlows = null;
    private static final int DEFAULT_LASTN = 100;
    private static final int DEFAULT_TOPNP = -1;
    private static final int DEFAULT_TOPNF = -1;
    private static final String NO_DPI_ENTRY_ERROR_MSG = "No DPI statistic entry, please check remote DPI engine is running";
    private static final String RECEIVED_TIME_ERROR_MSG = "No DPI statistic entry, please check remote DPI engine is running\n or correct receivedTime format: 'yyyy-MM-dd HH:mm:ss', ex:'2016-08-30 10:31:20'";

    @Override
    protected void execute() {
        boolean isTopn;
        DpiStatisticsManagerService dsms = DpisListCommand.get(DpiStatisticsManagerService.class);
        int topnP = -1;
        int topnF = -1;
        if (this.topnProtocols != null && (topnP = this.parseIntWithDefault(this.topnProtocols, -1)) <= 0) {
            this.print("Invalid detected protocol topn number: 0 < valid number <= 100", new Object[0]);
            return;
        }
        if (this.topnFlows != null && (topnF = this.parseIntWithDefault(this.topnFlows, -1)) <= 0) {
            this.print("Invalid known or unknown flows topn number: 0 < valid number <= 100", new Object[0]);
            return;
        }
        boolean bl = isTopn = topnP > 0 || topnF > 0;
        if (this.all) {
            this.dProtocols = true;
            this.kFlows = true;
            this.uFlows = true;
        }
        if (this.receivedTime != null) {
            DpiStatistics ds = isTopn ? dsms.getDpiStatistics(this.receivedTime, topnP, topnF) : dsms.getDpiStatistics(this.receivedTime);
            if (ds == null) {
                this.print(RECEIVED_TIME_ERROR_MSG, new Object[0]);
                return;
            }
            this.printDpiStatistics(0, ds);
        } else if (this.lastn != null) {
            int lastN = this.parseIntWithDefault(this.lastn, 100);
            List dsList = isTopn ? dsms.getDpiStatistics(lastN, topnP, topnF) : dsms.getDpiStatistics(lastN);
            this.printDpiStatisticsList(dsList);
        } else {
            if (this.permanent) {
                int i = 0;
                try {
                    while (true) {
                        DpiStatistics ds;
                        if ((ds = isTopn ? dsms.getDpiStatisticsLatest(topnP, topnF) : dsms.getDpiStatisticsLatest()) == null) {
                            this.print(NO_DPI_ENTRY_ERROR_MSG, new Object[0]);
                            return;
                        }
                        this.printDpiStatistics(i++, ds);
                        Thread.sleep(5000L);
                    }
                }
                catch (Exception e) {
                    return;
                }
            }
            DpiStatistics ds = isTopn ? dsms.getDpiStatisticsLatest(topnP, topnF) : dsms.getDpiStatisticsLatest();
            if (ds == null) {
                this.print(NO_DPI_ENTRY_ERROR_MSG, new Object[0]);
                return;
            }
            this.printDpiStatistics(0, ds);
        }
    }

    private int parseIntWithDefault(String lastN, int defaultN) {
        try {
            lastN = lastN.trim();
            return Integer.parseUnsignedInt(lastN);
        }
        catch (NumberFormatException e) {
            return defaultN;
        }
    }

    private void printDpiStatistics(int number, DpiStatistics ds) {
        if (this.outputJson()) {
            this.printDpiStatisticsJson(number, ds);
        } else {
            this.printDpiStatisticsClass(number, ds);
        }
    }

    private void printDpiStatisticsJson(int number, DpiStatistics ds) {
        String index;
        String string = index = number < 0 ? "  -  " : String.format("%5d", number);
        if ("".equals(ds.receivedTime())) {
            this.print("ReceivedTime is null, No valid DPI Statistics!", new Object[0]);
            return;
        }
        this.print("<--- (%s) DPI Statistics Time [%s] --->", index, ds.receivedTime());
        this.print("      %s", ds.toString());
        this.print("<--------------------------------------------------------->", new Object[0]);
    }

    private void printDpiStatisticsClass(int number, DpiStatistics ds) {
        int i;
        List fsiList;
        String printLine = "";
        String index = number < 0 ? "  -  " : String.format("%5d", number);
        DpiStatInfo dsi = ds.dpiStatInfo();
        if (dsi == null) {
            return;
        }
        if ("".equals(ds.receivedTime())) {
            this.print("ReceivedTime is null, No valid DPI Statistics!", new Object[0]);
            return;
        }
        this.print("<--- (%s) DPI Statistics Time [%s] --->", index, ds.receivedTime());
        this.print("Traffic Statistics:", new Object[0]);
        TrafficStatInfo tsi = dsi.trafficStatistics();
        printLine = String.format("        %-30s %-30s", "ethernet.bytes::", tsi.ethernetBytes());
        this.print("%s", printLine);
        printLine = String.format("        %-30s %-30s", "discarded.bytes:", tsi.discardedBytes());
        this.print("%s", printLine);
        printLine = String.format("        %-30s %-30s", "ip.packets:", tsi.ipPackets());
        this.print("%s", printLine);
        printLine = String.format("        %-30s %-30s", "total.packets:", tsi.totalPackets());
        this.print("%s", printLine);
        printLine = String.format("        %-30s %-30s", "ip.bytes:", tsi.ipBytes());
        this.print("%s", printLine);
        printLine = String.format("        %-30s %-30s", "avg.pkt.size:", tsi.avgPktSize());
        this.print("%s", printLine);
        printLine = String.format("        %-30s %-30s", "unique.flows:", tsi.uniqueFlows());
        this.print("%s", printLine);
        printLine = String.format("        %-30s %-30s", "tcp.packets:", tsi.tcpPackets());
        this.print("%s", printLine);
        printLine = String.format("        %-30s %-30s", "udp.packets:", tsi.tcpPackets());
        this.print("%s", printLine);
        printLine = String.format("        %-30s %-30s", "dpi.throughput.pps:", tsi.dpiThroughputPps() + " pps");
        this.print("%s", printLine);
        printLine = String.format("        %-30s %-30s", "dpi.throughput.bps:", tsi.dpiThroughputBps() + " bps");
        this.print("%s", printLine);
        printLine = String.format("        %-30s %-30s", "traffic.throughput.pps:", tsi.trafficThroughputPps() + " pps");
        this.print("%s", printLine);
        printLine = String.format("        %-30s %-30s", "traffic.throughput.bps:", tsi.trafficThroughputBps() + " bps");
        this.print("%s", printLine);
        printLine = String.format("        %-30s %-30s", "traffic.duration.sec:", tsi.trafficDurationSec() + " sec");
        this.print("%s", printLine);
        printLine = String.format("        %-30s %-30s", "guessed.flow.protos:", tsi.guessedFlowProtos());
        this.print("%s", printLine);
        if (this.dProtocols || this.topnProtocols != null) {
            this.print("", new Object[0]);
            this.print("Detected Protocols:", new Object[0]);
            List psiList = dsi.detectedProtos();
            if (psiList != null) {
                psiList.forEach(psi -> this.print(this.makeProtocolString((ProtocolStatInfo)psi), new Object[0]));
            }
        }
        if (this.kFlows || this.topnFlows != null) {
            this.print("", new Object[0]);
            this.print("Known Flows:", new Object[0]);
            fsiList = dsi.knownFlows();
            if (fsiList != null) {
                for (i = 0; i < fsiList.size(); ++i) {
                    this.print(this.makeFlowString((FlowStatInfo)fsiList.get(i), i), new Object[0]);
                }
            }
        }
        if (this.uFlows || this.topnFlows != null) {
            this.print("", new Object[0]);
            this.print("Unknown Flows:", new Object[0]);
            fsiList = dsi.unknownFlows();
            if (fsiList != null) {
                for (i = 0; i < fsiList.size(); ++i) {
                    this.print(this.makeFlowString((FlowStatInfo)fsiList.get(i), i), new Object[0]);
                }
            }
        }
        this.print("<--------------------------------------------------------->", new Object[0]);
    }

    private void printDpiStatisticsList(List<DpiStatistics> dsList) {
        if (this.outputJson()) {
            this.printDpiStatisticsListJson(dsList);
        } else {
            this.printDpiStatisticsListClass(dsList);
        }
    }

    private void printDpiStatisticsListJson(List<DpiStatistics> dsList) {
        for (int i = 0; i < dsList.size(); ++i) {
            this.printDpiStatisticsJson(i, dsList.get(i));
        }
    }

    private void printDpiStatisticsListClass(List<DpiStatistics> dsList) {
        for (int i = 0; i < dsList.size(); ++i) {
            this.printDpiStatisticsClass(i, dsList.get(i));
        }
    }

    private String makeProtocolString(ProtocolStatInfo psi) {
        StringBuffer sb = new StringBuffer("        ");
        sb.append(String.format("%-20s", psi.name()));
        sb.append(String.format(" %s: %-20s", "packets", psi.packets()));
        sb.append(String.format(" %s: %-20s", "bytes", psi.bytes()));
        sb.append(String.format(" %s: %-20s", "flows", psi.flows()));
        return sb.toString();
    }

    private String makeFlowString(FlowStatInfo fsi, int index) {
        StringBuffer sb = new StringBuffer("        ");
        sb.append(String.format("%-8d ", index));
        sb.append(String.format("%s ", fsi.protocol()));
        sb.append(String.format("%s", fsi.hostAName()));
        sb.append(String.format(":%s", fsi.hostAPort()));
        sb.append(String.format(" <-> %s", fsi.hostBName()));
        sb.append(String.format(":%s", fsi.hostBPort()));
        sb.append(String.format(" [proto: %d", fsi.detectedProtocol()));
        sb.append(String.format("/%s]", fsi.detectedProtocolName()));
        sb.append(String.format(" [%s pkts/", fsi.packets()));
        sb.append(String.format("%s bytes]", fsi.bytes()));
        String serverHostName = fsi.hostServerName();
        if (serverHostName != null && !"".equals(serverHostName)) {
            sb.append(String.format("[Host: %s]", serverHostName));
        }
        return sb.toString();
    }
}

