/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.Collection;
import java.util.Optional;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.packet.IpAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.tunnel.DefaultOpticalTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.DefaultTunnelDescription;
import org.onosproject.incubator.net.tunnel.IpTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.OpticalLogicId;
import org.onosproject.incubator.net.tunnel.OpticalTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelDescription;
import org.onosproject.incubator.net.tunnel.TunnelEndPoint;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.tunnel.TunnelProvider;
import org.onosproject.incubator.net.tunnel.TunnelService;
import org.onosproject.net.Annotations;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.provider.ProviderId;

@Command(scope="onos", name="tunnel-remove", description="Supports for removing tunnels. It's used by producers.")
public class TunnelRemoveCommand
extends AbstractShellCommand {
    @Option(name="-s", aliases={"--src"}, description="Source tunnel point. Only supports for IpTunnelEndPoint and OpticalTunnelEndPoint as end point now. If deletess a ODUK or OCH type tunnel, the formatter of this argument is DeviceId-PortNumber. Otherwise src means IP address.", required=false, multiValued=false)
    String src = null;
    @Option(name="-d", aliases={"--dst"}, description="Destination tunnel point. Only supports for IpTunnelEndPoint and OpticalTunnelEndPoint as end point now. If deletess a ODUK or OCH type tunnel, the formatter of this argument is DeviceId-PortNumber. Otherwise dst means IP address.", required=false, multiValued=false)
    String dst = null;
    @Option(name="-t", aliases={"--type"}, description="The type of tunnels, It includes MPLS, VLAN, VXLAN, GRE, ODUK, OCH", required=false, multiValued=false)
    String type = null;
    @Option(name="-i", aliases={"--tunnelId"}, description="the tunnel identity.", required=false, multiValued=false)
    String tunnelId = null;

    @Override
    protected void execute() {
        DefaultTunnelDescription tunnel = null;
        TunnelProvider service = TunnelRemoveCommand.get(TunnelProvider.class);
        ProviderId producerName = new ProviderId("default", "org.onosproject.provider.tunnel.default");
        if (!(this.isNull(this.src) || this.isNull(this.dst) || this.isNull(this.type))) {
            IpTunnelEndPoint srcPoint = null;
            IpTunnelEndPoint dstPoint = null;
            Tunnel.Type trueType = null;
            if ("MPLS".equals(this.type)) {
                trueType = Tunnel.Type.MPLS;
                srcPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)this.src));
                dstPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)this.dst));
            } else if ("VLAN".equals(this.type)) {
                trueType = Tunnel.Type.VLAN;
                srcPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)this.src));
                dstPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)this.dst));
            } else if ("VXLAN".equals(this.type)) {
                trueType = Tunnel.Type.VXLAN;
                srcPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)this.src));
                dstPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)this.dst));
            } else if ("GRE".equals(this.type)) {
                trueType = Tunnel.Type.GRE;
                srcPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)this.src));
                dstPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)this.dst));
            } else if ("ODUK".equals(this.type)) {
                trueType = Tunnel.Type.ODUK;
                String[] srcArray = this.src.split("/");
                String[] dstArray = this.dst.split("/");
                srcPoint = new DefaultOpticalTunnelEndPoint(producerName, Optional.of(DeviceId.deviceId((String)srcArray[0])), Optional.of(PortNumber.portNumber((String)srcArray[1])), null, OpticalTunnelEndPoint.Type.LAMBDA, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
                dstPoint = new DefaultOpticalTunnelEndPoint(producerName, Optional.of(DeviceId.deviceId((String)dstArray[0])), Optional.of(PortNumber.portNumber((String)dstArray[1])), null, OpticalTunnelEndPoint.Type.LAMBDA, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
            } else if ("OCH".equals(this.type)) {
                trueType = Tunnel.Type.OCH;
                String[] srcArray = this.src.split("/");
                String[] dstArray = this.dst.split("/");
                srcPoint = new DefaultOpticalTunnelEndPoint(producerName, Optional.of(DeviceId.deviceId((String)srcArray[0])), Optional.of(PortNumber.portNumber((String)srcArray[1])), null, OpticalTunnelEndPoint.Type.LAMBDA, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
                dstPoint = new DefaultOpticalTunnelEndPoint(producerName, Optional.of(DeviceId.deviceId((String)dstArray[0])), Optional.of(PortNumber.portNumber((String)dstArray[1])), null, OpticalTunnelEndPoint.Type.LAMBDA, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
            } else {
                this.print("Illegal tunnel type. Please input MPLS, VLAN, VXLAN, GRE, ODUK or OCH.", new Object[0]);
                return;
            }
            tunnel = new DefaultTunnelDescription(null, (TunnelEndPoint)srcPoint, (TunnelEndPoint)dstPoint, trueType, null, producerName, null, null, new SparseAnnotations[0]);
            service.tunnelRemoved((TunnelDescription)tunnel);
            return;
        }
        if (!this.isNull(this.tunnelId)) {
            TunnelId id = TunnelId.valueOf((String)this.tunnelId);
            tunnel = new DefaultTunnelDescription(id, null, null, null, null, producerName, null, null, new SparseAnnotations[0]);
            service.tunnelRemoved((TunnelDescription)tunnel);
            return;
        }
        if (!this.isNull(this.type)) {
            Tunnel.Type trueType = null;
            Collection tunnelSet = null;
            TunnelService tunnelService = TunnelRemoveCommand.get(TunnelService.class);
            if ("MPLS".equals(this.type)) {
                trueType = Tunnel.Type.MPLS;
            } else if ("VLAN".equals(this.type)) {
                trueType = Tunnel.Type.VLAN;
            } else if ("VXLAN".equals(this.type)) {
                trueType = Tunnel.Type.VXLAN;
            } else if ("GRE".equals(this.type)) {
                trueType = Tunnel.Type.GRE;
            } else if ("ODUK".equals(this.type)) {
                trueType = Tunnel.Type.ODUK;
            } else if ("OCH".equals(this.type)) {
                trueType = Tunnel.Type.OCH;
            } else {
                this.print("Illegal tunnel type. Please input MPLS, VLAN, VXLAN, GRE, ODUK or OCH.", new Object[0]);
                return;
            }
            tunnelSet = tunnelService.queryTunnel(trueType);
            if (tunnelSet != null) {
                for (Tunnel tunnelTemp : tunnelSet) {
                    tunnel = new DefaultTunnelDescription(tunnelTemp.tunnelId(), null, null, null, null, producerName, null, null, new SparseAnnotations[0]);
                    service.tunnelRemoved((TunnelDescription)tunnel);
                }
            }
        }
    }

    private boolean isNull(String s) {
        return s == null || "".equals(s);
    }
}

