/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.base.Preconditions;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Link;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkProvider;
import org.onosproject.net.link.LinkProviderRegistry;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;

@Command(scope="onos", name="annotate-link", description="Annotates network model entities")
public class AnnotateLinkCommand
extends AbstractShellCommand {
    static final ProviderId PID = new ProviderId("cli", "org.onosproject.cli", true);
    @Option(name="--both", description="Add to both direction")
    private boolean both = false;
    @Argument(index=0, name="srcConnectPoint", description="source Connect Point", required=true, multiValued=false)
    private String srcCp = null;
    @Argument(index=1, name="dstConnectPoint", description="destination Connect Point", required=true, multiValued=false)
    private String dstCp = null;
    @Argument(index=2, name="key", description="Annotation key", required=true, multiValued=false)
    private String key = null;
    @Argument(index=3, name="value", description="Annotation value (null to remove)", required=false, multiValued=false)
    private String value = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() {
        LinkService service = AnnotateLinkCommand.get(LinkService.class);
        ConnectPoint src = ConnectPoint.deviceConnectPoint((String)this.srcCp);
        ConnectPoint dst = ConnectPoint.deviceConnectPoint((String)this.dstCp);
        LinkProviderRegistry registry = AnnotateLinkCommand.get(LinkProviderRegistry.class);
        CliLinkProvider provider = new CliLinkProvider();
        LinkProviderService providerService = (LinkProviderService)registry.register((Provider)provider);
        try {
            providerService.linkDetected(this.description(service.getLink(src, dst), this.key, this.value));
            if (this.both) {
                providerService.linkDetected(this.description(service.getLink(dst, src), this.key, this.value));
            }
        }
        finally {
            registry.unregister((Provider)provider);
        }
    }

    private LinkDescription description(Link link, String key, String value) {
        Preconditions.checkNotNull((Object)key, (Object)"Key cannot be null");
        DefaultAnnotations.Builder builder = DefaultAnnotations.builder();
        if (value != null) {
            builder.set(key, value);
        } else {
            builder.remove(key);
        }
        return new DefaultLinkDescription(link.src(), link.dst(), link.type(), link.isExpected(), new SparseAnnotations[]{builder.build()});
    }

    private static final class CliLinkProvider
    implements LinkProvider {
        private CliLinkProvider() {
        }

        public ProviderId id() {
            return PID;
        }
    }
}

