/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net.vnet;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkAdminService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;

@Command(scope="onos", name="vnet-create-link", description="Creates a new virtual link in a network.")
public class VirtualLinkCreateCommand
extends AbstractShellCommand {
    @Argument(index=0, name="networkId", description="Network ID", required=true, multiValued=false)
    Long networkId = null;
    @Argument(index=1, name="srcDeviceId", description="Source device ID", required=true, multiValued=false)
    String srcDeviceId = null;
    @Argument(index=2, name="srcPortNum", description="Source port number", required=true, multiValued=false)
    Integer srcPortNum = null;
    @Argument(index=3, name="dstDeviceId", description="Destination device ID", required=true, multiValued=false)
    String dstDeviceId = null;
    @Argument(index=4, name="dstPortNum", description="Destination port number", required=true, multiValued=false)
    Integer dstPortNum = null;
    @Option(name="-b", aliases={"--bidirectional"}, description="If this argument is passed in then the virtual link created will be bidirectional, otherwise the link will be unidirectional.", required=false, multiValued=false)
    boolean bidirectional = false;

    @Override
    protected void execute() {
        VirtualNetworkAdminService service = VirtualLinkCreateCommand.get(VirtualNetworkAdminService.class);
        ConnectPoint src = new ConnectPoint((ElementId)DeviceId.deviceId((String)this.srcDeviceId), PortNumber.portNumber((long)this.srcPortNum.intValue()));
        ConnectPoint dst = new ConnectPoint((ElementId)DeviceId.deviceId((String)this.dstDeviceId), PortNumber.portNumber((long)this.dstPortNum.intValue()));
        service.createVirtualLink(NetworkId.networkId((long)this.networkId), src, dst);
        if (this.bidirectional) {
            service.createVirtualLink(NetworkId.networkId((long)this.networkId), dst, src);
        }
        this.print("Virtual link successfully created.", new Object[0]);
    }
}

