/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.List;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.packet.PacketProcessorEntry;
import org.onosproject.net.packet.PacketService;

@Command(scope="onos", name="packet-processors", description="Lists packet processors")
public class PacketProcessorsListCommand
extends AbstractShellCommand {
    private static final String FMT = "priority=%s, class=%s, packets=%d, avgNanos=%d";

    @Override
    protected void execute() {
        PacketService service = PacketProcessorsListCommand.get(PacketService.class);
        if (this.outputJson()) {
            this.print("%s", this.json(service.getProcessors()));
        } else {
            service.getProcessors().forEach(this::print);
        }
    }

    private JsonNode json(List<PacketProcessorEntry> processors) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (PacketProcessorEntry p : processors) {
            result.add((JsonNode)mapper.createObjectNode().put("priority", this.priorityFormat(p.priority())).put("class", p.processor().getClass().getName()).put("packets", p.invocations()).put("avgNanos", p.averageNanos()));
        }
        return result;
    }

    private void print(PacketProcessorEntry entry) {
        this.print(FMT, this.priorityFormat(entry.priority()), entry.processor().getClass().getName(), entry.invocations(), entry.averageNanos());
    }

    private String priorityFormat(int priority) {
        if (priority > 0x55555554) {
            return "observer(" + (priority - 0x55555554 - 1) + ")";
        }
        if (priority > 0x2AAAAAAA) {
            return "director(" + (priority - 0x2AAAAAAA - 1) + ")";
        }
        return "advisor(" + (priority - 1) + ")";
    }
}

