/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.Host;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.HostToHostIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;

@Command(scope="onos", name="push-random-intents", description="It installs random intents to test throughput. The maximum number of intents is determined by the number of hosts in the network. The command will push an intent for each unordered pair of hosts. The maximum intent number will be n(n-1)/2, where n represents the number of hosts present")
public class RandomIntentCommand
extends AbstractShellCommand {
    @Argument(index=0, name="count", description="Max number of intents to push. The value will not be taken into account if it exceeds the maximum number of intents the command can push", required=true, multiValued=false)
    String countString = null;
    private IntentService service;
    private HostService hostService;
    private int count;

    @Override
    protected void execute() {
        this.service = RandomIntentCommand.get(IntentService.class);
        this.hostService = RandomIntentCommand.get(HostService.class);
        this.count = Integer.parseInt(this.countString);
        if (this.count > 0) {
            Collection<Intent> intents = this.generateIntents();
            this.submitIntents(intents);
        } else {
            this.withdrawIntents();
        }
    }

    private Collection<Intent> generateIntents() {
        ArrayList hosts = Lists.newArrayList((Iterable)this.hostService.getHosts());
        ArrayList fullMesh = Lists.newArrayList();
        for (int i = 0; i < hosts.size(); ++i) {
            for (int j = i + 1; j < hosts.size(); ++j) {
                fullMesh.add(HostToHostIntent.builder().appId(this.appId()).one(((Host)hosts.get(i)).id()).two(((Host)hosts.get(j)).id()).build());
            }
        }
        Collections.shuffle(fullMesh);
        return fullMesh.subList(0, Math.min(this.count, fullMesh.size()));
    }

    private void submitIntents(Collection<Intent> intents) {
        for (Intent intent : intents) {
            this.service.submit(intent);
        }
        this.print("Submitted %d host to host intents.", intents.size());
    }

    private void withdrawIntents() {
        for (Intent intent : this.service.getIntents()) {
            if (!this.appId().equals(intent.appId())) continue;
            this.service.withdraw(intent);
        }
        this.print("Withdrew all randomly generated host to host intents.", new Object[0]);
    }

    @Override
    protected ApplicationId appId() {
        return RandomIntentCommand.get(CoreService.class).registerApplication("org.onosproject.cli-random");
    }
}

