/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.Device;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DriverService;
import org.onosproject.utils.Comparators;

@Command(scope="onos", name="devices", description="Lists all infrastructure devices")
public class DevicesListCommand
extends AbstractShellCommand {
    private static final String FMT = "id=%s, available=%s, local-status=%s, role=%s, type=%s, mfr=%s, hw=%s, sw=%s, serial=%s, chassis=%s, driver=%s%s";
    private static final String FMT_SHORT = "id=%s, available=%s, role=%s, type=%s, driver=%s";
    @Option(name="-s", aliases={"--short"}, description="Show short output only", required=false, multiValued=false)
    private boolean shortOnly = false;

    @Override
    protected void execute() {
        DeviceService deviceService = DevicesListCommand.get(DeviceService.class);
        if (this.outputJson()) {
            this.print("%s", this.json(DevicesListCommand.getSortedDevices(deviceService)));
        } else {
            for (Device device : DevicesListCommand.getSortedDevices(deviceService)) {
                this.printDevice(deviceService, device);
            }
        }
    }

    private JsonNode json(Iterable<Device> devices) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (Device device : devices) {
            result.add((JsonNode)this.jsonForEntity(device, Device.class));
        }
        return result;
    }

    public static List<Device> getSortedDevices(DeviceService service) {
        ArrayList devices = Lists.newArrayList((Iterable)service.getDevices());
        Collections.sort(devices, Comparators.ELEMENT_COMPARATOR);
        return devices;
    }

    protected void printDevice(DeviceService deviceService, Device device) {
        if (device != null) {
            String driver = DevicesListCommand.get(DriverService.class).getDriver(device.id()).name();
            if (this.shortOnly) {
                this.print(FMT_SHORT, device.id(), deviceService.isAvailable(device.id()), deviceService.getRole(device.id()), device.type(), driver);
            } else {
                this.print(FMT, device.id(), deviceService.isAvailable(device.id()), deviceService.localStatus(device.id()), deviceService.getRole(device.id()), device.type(), device.manufacturer(), device.hwVersion(), device.swVersion(), device.serialNumber(), device.chassisId(), driver, DevicesListCommand.annotations(device.annotations(), (Set<String>)ImmutableSet.of((Object)"driver")));
            }
        }
    }
}

