/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.DeviceId;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.DeviceAnnotationConfig;
import org.onosproject.net.provider.ProviderId;

@Command(scope="onos", name="annotate-device", description="Annotates network model entities")
public class AnnotateDeviceCommand
extends AbstractShellCommand {
    static final ProviderId PID = new ProviderId("cli", "org.onosproject.cli", true);
    @Argument(index=0, name="uri", description="Device ID", required=true, multiValued=false)
    String uri = null;
    @Argument(index=1, name="key", description="Annotation key", required=true, multiValued=false)
    String key = null;
    @Argument(index=2, name="value", description="Annotation value (null to remove)", required=false, multiValued=false)
    String value = null;
    @Option(name="--remove-config", description="Remove annotation config")
    private boolean removeCfg = false;

    @Override
    protected void execute() {
        NetworkConfigService netcfgService = AnnotateDeviceCommand.get(NetworkConfigService.class);
        DeviceId deviceId = DeviceId.deviceId((String)this.uri);
        if (this.key == null) {
            this.print("[ERROR] Annotation key not specified.", new Object[0]);
            return;
        }
        DeviceAnnotationConfig cfg = (DeviceAnnotationConfig)netcfgService.getConfig((Object)deviceId, DeviceAnnotationConfig.class);
        if (cfg == null) {
            cfg = new DeviceAnnotationConfig(deviceId);
        }
        if (this.removeCfg) {
            cfg.annotation(this.key);
        } else {
            cfg.annotation(this.key, this.value);
        }
        netcfgService.applyConfig((Object)deviceId, DeviceAnnotationConfig.class, cfg.node());
    }
}

