/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.BasicRegionConfig;
import org.onosproject.net.region.RegionId;

@Command(scope="onos", name="region-add-peer-loc", description="Adds a peer location annotation to a region.")
public class RegionAddPeerLocCommand
extends AbstractShellCommand {
    private static final String GEO = "geo";
    private static final String GRID = "grid";
    @Argument(index=0, name="id", description="Region ID", required=true, multiValued=false)
    String id = null;
    @Argument(index=1, name="peer", description="Peer region ID", required=true, multiValued=false)
    String peerId = null;
    @Argument(index=2, name="latOrY", description="Geo latitude / Grid y-coord", required=true, multiValued=false)
    Double latOrY = null;
    @Argument(index=3, name="longOrX", description="Geo longitude / Grid x-coord", required=true, multiValued=false)
    Double longOrX = null;
    @Argument(index=4, name="locType", description="Location type {geo|grid}", required=false, multiValued=false)
    String locType = "geo";

    @Override
    protected void execute() {
        RegionId regionId = RegionId.regionId((String)this.id);
        NetworkConfigService cfgService = RegionAddPeerLocCommand.get(NetworkConfigService.class);
        BasicRegionConfig cfg = (BasicRegionConfig)cfgService.getConfig((Object)regionId, BasicRegionConfig.class);
        cfg.addPeerLocMapping(this.peerId, this.locType, this.latOrY, this.longOrX).apply();
    }
}

