/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net.vnet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.virtual.VirtualNetwork;
import org.onosproject.incubator.net.virtual.VirtualNetworkAdminService;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.utils.Comparators;

@Command(scope="onos", name="vnets", description="Lists all virtual networks.")
public class VirtualNetworkListCommand
extends AbstractShellCommand {
    private static final String FMT_VIRTUAL_NETWORK = "tenantId=%s, networkId=%s";

    @Override
    protected void execute() {
        this.getSortedVirtualNetworks().forEach(this::printVirtualNetwork);
    }

    private List<VirtualNetwork> getSortedVirtualNetworks() {
        VirtualNetworkService service = VirtualNetworkListCommand.get(VirtualNetworkService.class);
        VirtualNetworkAdminService adminService = VirtualNetworkListCommand.get(VirtualNetworkAdminService.class);
        ArrayList<VirtualNetwork> virtualNetworks = new ArrayList<VirtualNetwork>();
        Set tenantSet = adminService.getTenantIds();
        tenantSet.forEach(tenantId -> virtualNetworks.addAll(service.getVirtualNetworks(tenantId)));
        Collections.sort(virtualNetworks, Comparators.VIRTUAL_NETWORK_COMPARATOR);
        return virtualNetworks;
    }

    private void printVirtualNetwork(VirtualNetwork virtualNetwork) {
        this.print(FMT_VIRTUAL_NETWORK, virtualNetwork.tenantId(), virtualNetwork.id());
    }
}

