/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net.vnet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.karaf.shell.console.completer.ArgumentCompleter;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onosproject.cli.AbstractChoicesCompleter;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.incubator.net.virtual.VirtualPort;
import org.onosproject.net.DeviceId;
import org.onosproject.utils.Comparators;

public class VirtualPortCompleter
extends AbstractChoicesCompleter {
    @Override
    protected List<String> choices() {
        String[] argsArray;
        ArgumentCompleter.ArgumentList args = this.getArgumentList();
        for (String str : argsArray = args.getArguments()) {
            if (!str.matches("[0-9]+")) continue;
            long networkId = Long.valueOf(str);
            String deviceId = argsArray[argsArray.length - 1];
            return this.getSortedVirtualPorts(networkId, deviceId).stream().map(virtualPort -> virtualPort.number().toString()).collect(Collectors.toList());
        }
        return Collections.singletonList("Missing network id");
    }

    private List<VirtualPort> getSortedVirtualPorts(long networkId, String deviceId) {
        VirtualNetworkService service = (VirtualNetworkService)DefaultServiceDirectory.getService(VirtualNetworkService.class);
        ArrayList<VirtualPort> virtualPorts = new ArrayList<VirtualPort>();
        virtualPorts.addAll(service.getVirtualPorts(NetworkId.networkId((long)networkId), DeviceId.deviceId((String)deviceId)));
        Collections.sort(virtualPorts, Comparators.VIRTUAL_PORT_COMPARATOR);
        return virtualPorts;
    }
}

