/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import java.util.Comparator;
import java.util.Map;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.metrics.MetricsService;
import org.onlab.util.Tools;
import org.onosproject.cli.AbstractShellCommand;

@Command(scope="onos", name="metrics", description="Prints metrics in the system")
public class MetricsListCommand
extends AbstractShellCommand {
    private static final String COUNTER = "counter";
    private static final String GAUGE = "gauge";
    private static final String VALUE = "value";
    private static final String METER = "meter";
    private static final String MEAN_RATE = "mean_rate";
    private static final String ONE_MIN_RATE = "1_min_rate";
    private static final String FIVE_MIN_RATE = "5_min_rate";
    private static final String FIFT_MIN_RATE = "15_min_rate";
    private static final String HISTOGRAM = "histogram";
    private static final String MIN = "min";
    private static final String MAX = "max";
    private static final String MEAN = "mean";
    private static final String STDDEV = "stddev";
    private static final String TIMER = "timer";
    @Argument(index=0, name="metricName", description="Name of Metric", required=false, multiValued=false)
    String metricName = null;

    @Override
    protected void execute() {
        MetricsService metricsService = MetricsListCommand.get(MetricsService.class);
        MetricFilter filter = this.metricName != null ? (name, metric) -> name.equals(this.metricName) : MetricFilter.ALL;
        TreeMultimap<String, Metric> matched = this.listMetrics(metricsService, filter);
        matched.asMap().forEach((name, metrics) -> {
            if (this.outputJson()) {
                metrics.forEach(metric -> this.print("%s", this.json((Metric)metric)));
            } else {
                metrics.forEach(metric -> this.printMetric((String)name, (Metric)metric));
            }
        });
    }

    private void printMetric(String name, Metric metric) {
        String heading;
        if (metric instanceof Counter) {
            heading = String.format("-- %s : [%s] --", name, "Counter");
            this.print(heading, new Object[0]);
            Counter counter = (Counter)metric;
            this.print("          count = %d", counter.getCount());
        } else if (metric instanceof Gauge) {
            heading = String.format("-- %s : [%s] --", name, "Gauge");
            this.print(heading, new Object[0]);
            Gauge gauge = (Gauge)metric;
            Object value = gauge.getValue();
            if (name.endsWith("EpochMs") && value instanceof Long) {
                this.print("          value = %s (%s)", value, Tools.defaultOffsetDataTime((long)((Long)value)));
            } else {
                this.print("          value = %s", value);
            }
        } else if (metric instanceof Histogram) {
            heading = String.format("-- %s : [%s] --", name, "Histogram");
            this.print(heading, new Object[0]);
            Histogram histogram = (Histogram)metric;
            Snapshot snapshot = histogram.getSnapshot();
            this.print("          count = %d", histogram.getCount());
            this.print("            min = %d", snapshot.getMin());
            this.print("            max = %d", snapshot.getMax());
            this.print("           mean = %f", snapshot.getMean());
            this.print("         stddev = %f", snapshot.getStdDev());
        } else if (metric instanceof Meter) {
            heading = String.format("-- %s : [%s] --", name, "Meter");
            this.print(heading, new Object[0]);
            Meter meter = (Meter)metric;
            this.print("          count = %d", meter.getCount());
            this.print("      mean rate = %f", meter.getMeanRate());
            this.print("  1-minute rate = %f", meter.getOneMinuteRate());
            this.print("  5-minute rate = %f", meter.getFiveMinuteRate());
            this.print(" 15-minute rate = %f", meter.getFifteenMinuteRate());
        } else if (metric instanceof Timer) {
            heading = String.format("-- %s : [%s] --", name, "Timer");
            this.print(heading, new Object[0]);
            Timer timer = (Timer)metric;
            Snapshot snapshot = timer.getSnapshot();
            this.print("          count = %d", timer.getCount());
            this.print("      mean rate = %f per second", timer.getMeanRate());
            this.print("  1-minute rate = %f per second", timer.getOneMinuteRate());
            this.print("  5-minute rate = %f per second", timer.getFiveMinuteRate());
            this.print(" 15-minute rate = %f per second", timer.getFifteenMinuteRate());
            this.print("            min = %f ms", this.nanoToMs(snapshot.getMin()));
            this.print("            max = %f ms", this.nanoToMs(snapshot.getMax()));
            this.print("           mean = %f ms", this.nanoToMs(snapshot.getMean()));
            this.print("         stddev = %f ms", this.nanoToMs(snapshot.getStdDev()));
        } else {
            heading = String.format("-- %s : [%s] --", name, metric.getClass().getCanonicalName());
            this.print(heading, new Object[0]);
            this.print("Unknown Metric type:{}", metric.getClass().getCanonicalName());
        }
        this.print(Strings.repeat((String)"-", (int)heading.length()), new Object[0]);
    }

    private TreeMultimap<String, Metric> listMetrics(MetricsService metricsService, MetricFilter filter) {
        TreeMultimap metrics = TreeMultimap.create(Comparator.naturalOrder(), (Comparator)Ordering.arbitrary());
        Map counters = metricsService.getCounters(filter);
        for (Map.Entry entry : counters.entrySet()) {
            metrics.put((Object)((String)entry.getKey()), (Object)((Metric)entry.getValue()));
        }
        Map gauges = metricsService.getGauges(filter);
        for (Map.Entry entry : gauges.entrySet()) {
            metrics.put((Object)((String)entry.getKey()), (Object)((Metric)entry.getValue()));
        }
        Map map = metricsService.getHistograms(filter);
        for (Map.Entry entry : map.entrySet()) {
            metrics.put((Object)((String)entry.getKey()), (Object)((Metric)entry.getValue()));
        }
        Map map2 = metricsService.getMeters(filter);
        for (Map.Entry entry : map2.entrySet()) {
            metrics.put((Object)((String)entry.getKey()), (Object)((Metric)entry.getValue()));
        }
        Map map3 = metricsService.getTimers(filter);
        for (Map.Entry entry : map3.entrySet()) {
            metrics.put((Object)((String)entry.getKey()), (Object)((Metric)entry.getValue()));
        }
        return metrics;
    }

    private ObjectNode json(Metric metric) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode objectNode = mapper.createObjectNode();
        ObjectNode dataNode = mapper.createObjectNode();
        if (metric instanceof Counter) {
            dataNode.put(COUNTER, ((Counter)metric).getCount());
            objectNode.set(COUNTER, (JsonNode)dataNode);
        } else if (metric instanceof Gauge) {
            objectNode.put(VALUE, ((Gauge)metric).getValue().toString());
            objectNode.set(GAUGE, (JsonNode)dataNode);
        } else if (metric instanceof Meter) {
            dataNode.put(COUNTER, ((Meter)metric).getCount());
            dataNode.put(MEAN_RATE, ((Meter)metric).getMeanRate());
            dataNode.put(ONE_MIN_RATE, ((Meter)metric).getOneMinuteRate());
            dataNode.put(FIVE_MIN_RATE, ((Meter)metric).getFiveMinuteRate());
            dataNode.put(FIFT_MIN_RATE, ((Meter)metric).getFifteenMinuteRate());
            objectNode.set(METER, (JsonNode)dataNode);
        } else if (metric instanceof Histogram) {
            dataNode.put(COUNTER, ((Histogram)metric).getCount());
            dataNode.put(MEAN, ((Histogram)metric).getSnapshot().getMean());
            dataNode.put(MIN, ((Histogram)metric).getSnapshot().getMin());
            dataNode.put(MAX, ((Histogram)metric).getSnapshot().getMax());
            dataNode.put(STDDEV, ((Histogram)metric).getSnapshot().getStdDev());
            objectNode.set(HISTOGRAM, (JsonNode)dataNode);
        } else if (metric instanceof Timer) {
            dataNode.put(COUNTER, ((Timer)metric).getCount());
            dataNode.put(MEAN_RATE, ((Timer)metric).getMeanRate());
            dataNode.put(ONE_MIN_RATE, ((Timer)metric).getOneMinuteRate());
            dataNode.put(FIVE_MIN_RATE, ((Timer)metric).getFiveMinuteRate());
            dataNode.put(FIFT_MIN_RATE, ((Timer)metric).getFifteenMinuteRate());
            dataNode.put(MEAN, this.nanoToMs(((Timer)metric).getSnapshot().getMean()));
            dataNode.put(MIN, this.nanoToMs(((Timer)metric).getSnapshot().getMin()));
            dataNode.put(MAX, this.nanoToMs(((Timer)metric).getSnapshot().getMax()));
            dataNode.put(STDDEV, this.nanoToMs(((Timer)metric).getSnapshot().getStdDev()));
            objectNode.set(TIMER, (JsonNode)dataNode);
        }
        return objectNode;
    }

    private double nanoToMs(double nano) {
        return nano / 1000000.0;
    }
}

