/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.karaf.shell.console.completer.ArgumentCompleter;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onosproject.cli.AbstractChoicesCompleter;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;

public class PortNumberCompleter
extends AbstractChoicesCompleter {
    protected DeviceId lookForDeviceId() {
        ArgumentCompleter.ArgumentList args = this.getArgumentList();
        DeviceService deviceService = (DeviceService)DefaultServiceDirectory.getService(DeviceService.class);
        Device dev = null;
        for (String str : args.getArguments()) {
            if (!str.contains(":") || (dev = deviceService.getDevice(DeviceId.deviceId((String)str))) == null) continue;
            return dev.id();
        }
        return null;
    }

    @Override
    protected List<String> choices() {
        DeviceId deviceId = this.lookForDeviceId();
        if (deviceId == null) {
            return Collections.emptyList();
        }
        DeviceService deviceService = (DeviceService)DefaultServiceDirectory.getService(DeviceService.class);
        return StreamSupport.stream(deviceService.getPorts(deviceId).spliterator(), false).map(port -> port.number().toString()).collect(Collectors.toList());
    }
}

