/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.packet.VlanId;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.VlanQuery;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;

@Command(scope="onos", name="port-query-vlans", description="Lists all unused VLAN-IDs on port")
public class PortQueryVlansCommand
extends AbstractShellCommand {
    private static final String AVAIL_VLANS = "VLAN-ID: %s";
    private static final String VLAN_NOT_AVAILABLE = "No unused VLAN-ID";
    private static final String FMT = "port=%s, state=%s, type=%s, speed=%s%s";
    private static final String NO_SUPPORT = "Device not supporting VLAN-ID retrieval";
    private static final String FAILURE = "Failed to retrieve VLAN information: ";
    @Argument(index=0, name="port", description="Port Description", required=true, multiValued=true)
    private String[] ports;

    @Override
    protected void execute() {
        DeviceService service = PortQueryVlansCommand.get(DeviceService.class);
        for (String portStr : this.ports) {
            ConnectPoint connectPoint = ConnectPoint.deviceConnectPoint((String)portStr);
            Port port = service.getPort(connectPoint.deviceId(), connectPoint.port());
            this.printPort(port);
            this.printVlans(port);
        }
    }

    private void printPort(Port port) {
        String portName = this.portName(port.number());
        String portIsEnabled = port.isEnabled() ? "enabled" : "disabled";
        String portType = port.type().toString().toLowerCase();
        String annotations = PortQueryVlansCommand.annotations(port.annotations());
        this.print(FMT, portName, portIsEnabled, portType, port.portSpeed(), annotations);
    }

    private String portName(PortNumber port) {
        return port.equals((Object)PortNumber.LOCAL) ? "local" : port.toString();
    }

    private void printVlans(Port port) {
        DeviceService deviceService = PortQueryVlansCommand.get(DeviceService.class);
        DriverService driverService = PortQueryVlansCommand.get(DriverService.class);
        DeviceId deviceId = (DeviceId)port.element().id();
        Device device = deviceService.getDevice(deviceId);
        if (!device.is(VlanQuery.class)) {
            this.print(NO_SUPPORT, new Object[0]);
            return;
        }
        DriverHandler h = driverService.createHandler(deviceId, new String[0]);
        VlanQuery vlanQuery = (VlanQuery)h.behaviour(VlanQuery.class);
        try {
            Set vlanIds = vlanQuery.queryVlanIds(port.number());
            if (vlanIds.isEmpty()) {
                this.print(VLAN_NOT_AVAILABLE, new Object[0]);
            } else {
                this.print(AVAIL_VLANS, PortQueryVlansCommand.getRanges(vlanIds).toString());
            }
        }
        catch (Exception e) {
            this.print(FAILURE + e.getMessage(), new Object[0]);
        }
    }

    private static ArrayList getRanges(Set<VlanId> vlans) {
        int i = 0;
        short[] vlanArray = new short[vlans.size()];
        for (VlanId vlanId : vlans) {
            int n = i;
            i = (short)(i + 1);
            vlanArray[n] = vlanId.toShort();
        }
        Arrays.sort(vlanArray);
        ArrayList<Object> ranges = new ArrayList<Object>();
        int rStart = 0;
        short rEnd = 0;
        for (i = 2; i < vlanArray.length; i = (int)((short)(i + 1))) {
            if (vlanArray[i] == vlanArray[i - 1] + 1 && vlanArray[i] == vlanArray[i - 2] + 2) {
                if (rEnd == vlanArray[i - 1]) {
                    rEnd = vlanArray[i];
                    continue;
                }
                rStart = vlanArray[i - 2];
                rEnd = vlanArray[i];
                continue;
            }
            if (rEnd == vlanArray[i - 1]) {
                ranges.add(rStart + "-" + rEnd);
                continue;
            }
            if (vlanArray[i] == vlanArray[i - 1] + 1) continue;
            if (vlanArray[i - 1] == vlanArray[i - 2] + 1) {
                ranges.add(vlanArray[i - 2]);
            }
            ranges.add(vlanArray[i - 1]);
        }
        if (rEnd == vlanArray[vlanArray.length - 1]) {
            ranges.add(rStart + "-" + rEnd);
        } else {
            if (vlanArray[vlanArray.length - 1] == vlanArray[vlanArray.length - 2] + 1) {
                ranges.add(vlanArray[vlanArray.length - 2]);
            }
            ranges.add(vlanArray[vlanArray.length - 1]);
        }
        return ranges;
    }
}

