/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net.vnet;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkAdminService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.PortNumber;

@Command(scope="onos", name="vnet-create-host", description="Creates a new virtual host in a network.")
public class VirtualHostCreateCommand
extends AbstractShellCommand {
    @Argument(index=0, name="networkId", description="Network ID", required=true, multiValued=false)
    Long networkId = null;
    @Argument(index=1, name="mac", description="Mac address", required=true, multiValued=false)
    String mac = null;
    @Argument(index=2, name="vlan", description="Vlan", required=true, multiValued=false)
    short vlan;
    @Argument(index=3, name="hostLocationDeviceId", description="Host location device ID", required=true, multiValued=false)
    String hostLocationDeviceId;
    @Argument(index=4, name="hostLocationPortNumber", description="Host location port number", required=true, multiValued=false)
    long hostLocationPortNumber;
    @Option(name="--hostIp", description="Host IP addresses.  Can be specified multiple times.", required=false, multiValued=true)
    protected String[] hostIpStrings;

    @Override
    protected void execute() {
        VirtualNetworkAdminService service = VirtualHostCreateCommand.get(VirtualNetworkAdminService.class);
        HashSet hostIps = new HashSet();
        if (this.hostIpStrings != null) {
            Arrays.stream(this.hostIpStrings).forEach(s -> hostIps.add(IpAddress.valueOf((String)s)));
        }
        HostLocation hostLocation = new HostLocation(DeviceId.deviceId((String)this.hostLocationDeviceId), PortNumber.portNumber((long)this.hostLocationPortNumber), System.currentTimeMillis());
        MacAddress macAddress = MacAddress.valueOf((String)this.mac);
        VlanId vlanId = VlanId.vlanId((short)this.vlan);
        service.createVirtualHost(NetworkId.networkId((long)this.networkId), HostId.hostId((MacAddress)macAddress, (VlanId)vlanId), macAddress, vlanId, hostLocation, hostIps);
        this.print("Virtual host successfully created.", new Object[0]);
    }
}

