/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.packet.VlanId;
import org.onosproject.cli.net.DevicesListCommand;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.InterfaceConfig;
import org.onosproject.net.device.DeviceInterfaceDescription;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;

@Command(scope="onos", name="device-interfaces", description="Lists all interfaces or interfaces of a device.")
public class DeviceInterfacesListCommand
extends DevicesListCommand {
    private static final String FORMAT = "%s";
    private static final String MODE_FORMAT = " mode=";
    private static final String ACCESS_MODE = "access";
    private static final String TRUNK_MODE = "trunk";
    private static final String VLAN_FORMAT = " vlan=";
    private static final String LIMIT_FORMAT = " rate-limit=";
    private static final String ERROR_RESULT = "Cannot retrieve interfaces for device";
    private static final String NO_INTERFACES = "No interfaces found";
    private static final String PERCENT = "%%";
    @Argument(index=0, name="uri", description="Device ID", required=false, multiValued=false)
    private String uri = null;

    @Override
    protected void execute() {
        DeviceService deviceService = DeviceInterfacesListCommand.get(DeviceService.class);
        DriverService driverService = DeviceInterfacesListCommand.get(DriverService.class);
        if (this.uri == null) {
            for (Device device : DeviceInterfacesListCommand.getSortedDevices(deviceService)) {
                this.printDevice(deviceService, driverService, device);
            }
        } else {
            Device device = deviceService.getDevice(DeviceId.deviceId((String)this.uri));
            this.printDevice(deviceService, driverService, device);
        }
    }

    private void printDevice(DeviceService deviceService, DriverService driverService, Device device) {
        super.printDevice(deviceService, device);
        if (!device.is(InterfaceConfig.class)) {
            this.print(ERROR_RESULT, new Object[0]);
            return;
        }
        DriverHandler h = driverService.createHandler(device.id(), new String[0]);
        InterfaceConfig interfaceConfig = (InterfaceConfig)h.behaviour(InterfaceConfig.class);
        List interfaces = interfaceConfig.getInterfaces();
        if (interfaces == null) {
            this.print(ERROR_RESULT, new Object[0]);
        } else if (interfaces.isEmpty()) {
            this.print(NO_INTERFACES, new Object[0]);
        } else {
            interfaces.forEach(this::printInterface);
        }
    }

    private void printInterface(DeviceInterfaceDescription intf) {
        StringBuilder formatStringBuilder = new StringBuilder(FORMAT);
        if (intf.mode().equals((Object)DeviceInterfaceDescription.Mode.ACCESS)) {
            formatStringBuilder.append(MODE_FORMAT).append(ACCESS_MODE).append(VLAN_FORMAT);
            formatStringBuilder.append(((VlanId)intf.vlans().get(0)).toString());
        } else if (intf.mode().equals((Object)DeviceInterfaceDescription.Mode.TRUNK)) {
            formatStringBuilder.append(MODE_FORMAT).append(TRUNK_MODE).append(VLAN_FORMAT);
            for (int i = 0; i < intf.vlans().size(); ++i) {
                formatStringBuilder.append(intf.vlans().get(i));
                if (i == intf.vlans().size() - 1) continue;
                formatStringBuilder.append(",");
            }
        }
        if (intf.isRateLimited()) {
            formatStringBuilder.append(LIMIT_FORMAT);
            formatStringBuilder.append(intf.rateLimit());
            formatStringBuilder.append(PERCENT);
        }
        this.print(formatStringBuilder.toString(), intf.name());
    }
}

