/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.key.DeviceKey;
import org.onosproject.net.key.DeviceKeyAdminService;
import org.onosproject.net.key.DeviceKeyId;

@Command(scope="onos", name="device-key-add", description="Adds a device key. Adding a new device key with the same id will replace the existing device key.")
public class DeviceKeyAddCommand
extends AbstractShellCommand {
    private static final String COMMUNITY_NAME = "CommunityName";
    private static final String USERNAME = "UsernamePassword";
    @Argument(index=0, name="id", description="Device Key ID", required=true, multiValued=false)
    String id = null;
    @Argument(index=1, name="type", description="Device Key Type, it includes CommunityName, UsernamePassword.", required=true, multiValued=false)
    String type = null;
    @Option(name="-c", aliases={"--communityName"}, description="Device Key Community Name", required=false, multiValued=false)
    String communityName = null;
    @Option(name="-l", aliases={"--label"}, description="Device Key Label", required=false, multiValued=false)
    String label = null;
    @Option(name="-u", aliases={"--username"}, description="Device Key Username", required=false, multiValued=false)
    String username = null;
    @Option(name="-p", aliases={"--password"}, description="Device Key Password", required=false, multiValued=false)
    String password = null;

    @Override
    protected void execute() {
        DeviceKeyAdminService service = DeviceKeyAddCommand.get(DeviceKeyAdminService.class);
        DeviceKey deviceKey = null;
        if (this.type.equalsIgnoreCase(COMMUNITY_NAME)) {
            deviceKey = DeviceKey.createDeviceKeyUsingCommunityName((DeviceKeyId)DeviceKeyId.deviceKeyId((String)this.id), (String)this.label, (String)this.communityName);
        } else if (this.type.equalsIgnoreCase(USERNAME)) {
            deviceKey = DeviceKey.createDeviceKeyUsingUsernamePassword((DeviceKeyId)DeviceKeyId.deviceKeyId((String)this.id), (String)this.label, (String)this.username, (String)this.password);
        } else {
            this.print("Invalid Device key type: {}", this.type);
            return;
        }
        service.addKey(deviceKey);
        this.print("Device Key successfully added.", new Object[0]);
    }
}

