/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.packet.IpAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.ControllerConfig;
import org.onosproject.net.behaviour.ControllerInfo;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;

@Command(scope="onos", name="device-setcontrollers", description="sets the list of controllers for the given infrastructure device")
public class DeviceSetControllersCommand
extends AbstractShellCommand {
    @Argument(index=0, name="uri", description="Device ID", required=true, multiValued=false)
    String uri = null;
    @Argument(index=1, name="controllersListStrings", description="list of controllers to set for the specified device", required=false, multiValued=true)
    String[] controllersListStrings = null;
    @Option(name="--remove", description="Remove specified controllers configuration")
    private boolean removeCont = false;
    @Option(name="--remove-all", description="Remove all controllers configuration, does not require any input")
    private boolean removeAll = false;
    private DeviceId deviceId;
    private List<ControllerInfo> controllers = new ArrayList<ControllerInfo>();

    @Override
    protected void execute() {
        if (this.controllersListStrings == null && !this.removeCont && !this.removeAll) {
            this.print("No controller are given, skipping.", new Object[0]);
            return;
        }
        if (this.controllersListStrings != null) {
            Arrays.asList(this.controllersListStrings).forEach(cInfoString -> {
                ControllerInfo controllerInfo = this.parseCInfoString((String)cInfoString);
                if (controllerInfo != null) {
                    this.controllers.add(controllerInfo);
                }
            });
        }
        DriverService service = DeviceSetControllersCommand.get(DriverService.class);
        this.deviceId = DeviceId.deviceId((String)this.uri);
        DriverHandler h = service.createHandler(this.deviceId, new String[0]);
        ControllerConfig config = (ControllerConfig)h.behaviour(ControllerConfig.class);
        this.print("before:", new Object[0]);
        config.getControllers().forEach(c -> this.print(c.target(), new Object[0]));
        try {
            if (this.removeAll) {
                if (!this.controllers.isEmpty()) {
                    this.print("Controllers list should be empty to remove all controllers", new Object[0]);
                } else {
                    List controllersToRemove = config.getControllers();
                    controllersToRemove.forEach(c -> this.print("Will remove " + c.target(), new Object[0]));
                    config.removeControllers(controllersToRemove);
                }
            } else if (this.controllers.isEmpty()) {
                this.print("Controllers list is empty, cannot set/remove empty controllers", new Object[0]);
            } else if (this.removeCont) {
                this.print("Will remove specified controllers", new Object[0]);
                config.removeControllers(this.controllers);
            } else {
                this.print("Will add specified controllers", new Object[0]);
                config.setControllers(this.controllers);
            }
        }
        catch (NullPointerException e) {
            this.print("No Device with requested parameters {} ", this.uri);
        }
        this.print("after:", new Object[0]);
        config.getControllers().forEach(c -> this.print(c.target(), new Object[0]));
        this.print("size %d", config.getControllers().size());
    }

    private ControllerInfo parseCInfoString(String cInfoString) {
        String[] config = cInfoString.split(",");
        if (config.length == 2) {
            String[] pair = config[1].split("=");
            if (pair.length != 2) {
                this.print("Wrong format {}", config[1]);
                return null;
            }
            DefaultAnnotations annotation = DefaultAnnotations.builder().set(pair[0], pair[1]).build();
            return this.getControllerInfo((Annotations)annotation, config[0]);
        }
        return this.getControllerInfo(null, config[0]);
    }

    private ControllerInfo getControllerInfo(Annotations annotation, String s) {
        String[] data = s.split(":");
        if (data.length != 3) {
            this.print("Wrong format of the controller %s, should be in the format <protocol>:<ip>:<port>", s);
            return null;
        }
        String type = data[0];
        IpAddress ip = IpAddress.valueOf((String)data[1]);
        int port = Integer.parseInt(data[2]);
        if (annotation != null) {
            return new ControllerInfo(ip, port, type, annotation);
        }
        return new ControllerInfo(ip, port, type);
    }
}

