/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cluster.ClusterAdminService;
import org.onosproject.cluster.Node;

@Command(scope="onos", name="storage-nodes", description="Lists all storage nodes")
public class StorageNodesListCommand
extends AbstractShellCommand {
    private static final String FMT = "id=%s, address=%s:%s";

    @Override
    protected void execute() {
        ClusterAdminService service = StorageNodesListCommand.get(ClusterAdminService.class);
        ArrayList nodes = Lists.newArrayList((Iterable)service.getConsensusNodes());
        Collections.sort(nodes, Comparator.comparing(Node::id));
        if (this.outputJson()) {
            this.print("%s", this.json(nodes));
        } else {
            for (Node node : nodes) {
                this.print(FMT, node.id(), node.host(), node.tcpPort());
            }
        }
    }

    private JsonNode json(List<Node> nodes) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (Node node : nodes) {
            ObjectNode newNode = mapper.createObjectNode().put("id", node.id().toString()).put("ip", node.ip().toString()).put("host", node.host()).put("tcpPort", node.tcpPort());
            result.add((JsonNode)newNode);
        }
        return result;
    }
}

