/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.PortStatistics;

@Command(scope="onos", name="portstats", description="Lists statistics of all ports in the system")
public class DevicePortStatsCommand
extends AbstractShellCommand {
    private static final String FORMAT = "   port=%s, pktRx=%s, pktTx=%s, bytesRx=%s, bytesTx=%s, pktRxDrp=%s, pktTxDrp=%s, Dur=%s";

    @Override
    protected void execute() {
        DeviceService deviceService = DevicePortStatsCommand.get(DeviceService.class);
        deviceService.getDevices().forEach(d -> this.printPortStats(d.id(), deviceService.getPortStatistics(d.id())));
    }

    private void printPortStats(DeviceId deviceId, Iterable<PortStatistics> portStats) {
        this.print("deviceId=%s", deviceId);
        for (PortStatistics stat : portStats) {
            this.print(FORMAT, stat.port(), stat.packetsReceived(), stat.packetsSent(), stat.bytesReceived(), stat.bytesSent(), stat.packetsRxDropped(), stat.packetsTxDropped(), stat.durationSec());
        }
    }
}

