/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.Comparators;
import org.onosproject.net.Device;
import org.onosproject.net.device.DeviceService;

@Command(scope="onos", name="devices", description="Lists all infrastructure devices")
public class DevicesListCommand
extends AbstractShellCommand {
    private static final String FMT = "id=%s, available=%s, role=%s, type=%s, mfr=%s, hw=%s, sw=%s, serial=%s%s";

    @Override
    protected void execute() {
        DeviceService service = DevicesListCommand.get(DeviceService.class);
        if (this.outputJson()) {
            this.print("%s", this.json(DevicesListCommand.getSortedDevices(service)));
        } else {
            for (Device device : DevicesListCommand.getSortedDevices(service)) {
                this.printDevice(service, device);
            }
        }
    }

    private JsonNode json(Iterable<Device> devices) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (Device device : devices) {
            result.add((JsonNode)this.jsonForEntity(device, Device.class));
        }
        return result;
    }

    public static List<Device> getSortedDevices(DeviceService service) {
        ArrayList devices = Lists.newArrayList((Iterable)service.getDevices());
        Collections.sort(devices, Comparators.ELEMENT_COMPARATOR);
        return devices;
    }

    protected void printDevice(DeviceService service, Device device) {
        if (device != null) {
            this.print(FMT, device.id(), service.isAvailable(device.id()), service.getRole(device.id()), device.type(), device.manufacturer(), device.hwVersion(), device.swVersion(), device.serialNumber(), DevicesListCommand.annotations(device.annotations()));
        }
    }
}

