/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.security;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.app.ApplicationAdminService;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.core.Application;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.Permission;

@Command(scope="onos", name="perm", description="Manages application permissions")
public class PermissionCommand
extends AbstractShellCommand {
    static final String ADD = "add";
    static final String REMOVE = "remove";
    static final String LIST = "list";
    static final String CLEAR = "clear";
    @Argument(index=0, name="command", description="Command name (add|remove)", required=true, multiValued=false)
    String command = null;
    @Argument(index=1, name="name", description="Application name", required=true, multiValued=false)
    String name = null;
    @Argument(index=2, name="permissions", description="List of permissions", required=false, multiValued=true)
    String[] permissions = null;

    @Override
    protected void execute() {
        ApplicationAdminService applicationAdminService = PermissionCommand.get(ApplicationAdminService.class);
        HashSet newPermSet = Sets.newHashSet();
        if (this.command.equals(ADD)) {
            ApplicationId appId = applicationAdminService.getId(this.name);
            if (appId == null) {
                this.print("No such application: %s", this.name);
                return;
            }
            Application app = applicationAdminService.getApplication(appId);
            for (String perm2 : this.permissions) {
                try {
                    Permission permission = Permission.valueOf((String)perm2);
                    newPermSet.add(permission);
                }
                catch (IllegalArgumentException e) {
                    this.print("%s is not a valid permission.", perm2);
                    return;
                }
            }
            Set oldPermSet = applicationAdminService.getPermissions(appId);
            if (oldPermSet != null) {
                newPermSet.addAll(oldPermSet);
            } else {
                newPermSet.addAll(app.permissions());
            }
            applicationAdminService.setPermissions(appId, (Set)ImmutableSet.copyOf((Collection)newPermSet));
        } else if (this.command.equals(REMOVE)) {
            ApplicationId appId = applicationAdminService.getId(this.name);
            Application app = applicationAdminService.getApplication(appId);
            if (appId == null) {
                this.print("No such application: %s", this.name);
                return;
            }
            Set oldPermSet = applicationAdminService.getPermissions(appId);
            if (oldPermSet == null) {
                oldPermSet = app.permissions();
            }
            HashSet clearPermSet = Sets.newHashSet((Object[])this.permissions);
            newPermSet.addAll(oldPermSet.stream().filter(perm -> !clearPermSet.contains(perm.name().toUpperCase())).collect(Collectors.toList()));
            applicationAdminService.setPermissions(appId, (Set)ImmutableSet.copyOf((Collection)newPermSet));
        } else if (this.command.equals(CLEAR)) {
            ApplicationId appId = applicationAdminService.getId(this.name);
            if (appId == null) {
                this.print("No such application: %s", this.name);
                return;
            }
            applicationAdminService.setPermissions(appId, (Set)ImmutableSet.of());
            this.print("Cleared the permission list of %s.", appId.name());
        } else if (this.command.equals(LIST)) {
            ApplicationId appId = applicationAdminService.getId(this.name);
            if (appId == null) {
                this.print("No such application: %s", this.name);
                return;
            }
            Application app = applicationAdminService.getApplication(appId);
            Set userPermissions = applicationAdminService.getPermissions(appId);
            Set defaultPermissions = app.permissions();
            this.print("Application Role", new Object[0]);
            this.print("\trole=%s", app.role().name());
            if (defaultPermissions != null) {
                if (!defaultPermissions.isEmpty()) {
                    this.print("Default permissions (specified in app.xml)", new Object[0]);
                    for (Permission perm3 : defaultPermissions) {
                        this.print("\tpermission=%s", perm3.name());
                    }
                } else {
                    this.print("(No default permissions specified in app.xml)", new Object[0]);
                }
            }
            if (userPermissions != null) {
                if (!userPermissions.isEmpty()) {
                    this.print("User permissions", new Object[0]);
                    for (Permission perm3 : userPermissions) {
                        this.print("\tpermission=%s", perm3.name());
                    }
                } else {
                    this.print("(User has removed all the permissions", new Object[0]);
                }
            }
        }
    }
}

