/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.app;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.app.ApplicationService;
import org.onosproject.app.ApplicationState;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.Comparators;
import org.onosproject.core.Application;

@Command(scope="onos", name="apps", description="Lists application information")
public class ApplicationsListCommand
extends AbstractShellCommand {
    private static final String FMT = "%s id=%d, name=%s, version=%s, origin=%s, description=%s, features=%s, featuresRepo=%s, permissions=%s";
    private static final String SHORT_FMT = "%s %3d %-32s %-8s %s";
    @Option(name="-s", aliases={"--short"}, description="Show short output only", required=false, multiValued=false)
    private boolean shortOnly = false;
    @Option(name="-a", aliases={"--active"}, description="Show active only", required=false, multiValued=false)
    private boolean activeOnly = false;

    @Override
    protected void execute() {
        ApplicationService service = ApplicationsListCommand.get(ApplicationService.class);
        ArrayList apps = Lists.newArrayList((Iterable)service.getApplications());
        Collections.sort(apps, Comparators.APP_COMPARATOR);
        if (this.outputJson()) {
            this.print("%s", this.json(service, apps));
        } else {
            for (Application app : apps) {
                boolean isActive;
                boolean bl = isActive = service.getState(app.id()) == ApplicationState.ACTIVE;
                if ((!this.activeOnly || !isActive) && this.activeOnly) continue;
                if (this.shortOnly) {
                    this.print(SHORT_FMT, isActive ? "*" : " ", app.id().id(), app.id().name(), app.version(), app.description());
                    continue;
                }
                this.print(FMT, isActive ? "*" : " ", app.id().id(), app.id().name(), app.version(), app.origin(), app.description(), app.features(), app.featuresRepo().isPresent() ? ((URI)app.featuresRepo().get()).toString() : "", app.permissions());
            }
        }
    }

    private JsonNode json(ApplicationService service, List<Application> apps) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (Application app : apps) {
            boolean isActive;
            boolean bl = isActive = service.getState(app.id()) == ApplicationState.ACTIVE;
            if ((!this.activeOnly || !isActive) && this.activeOnly) continue;
            result.add((JsonNode)this.jsonForEntity(app, Application.class));
        }
        return result;
    }
}

