/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.Comparators;
import org.onosproject.net.host.HostService;
import org.onosproject.net.host.InterfaceIpAddress;
import org.onosproject.net.host.PortAddresses;

@Command(scope="onos", name="address-bindings", description="Lists all configured address port bindings.")
public class AddressBindingsListCommand
extends AbstractShellCommand {
    private static final String FORMAT = "port=%s/%s, ip(s)=%s, mac=%s, vlan=%s";

    @Override
    protected void execute() {
        HostService hostService = AddressBindingsListCommand.get(HostService.class);
        ArrayList addresses = Lists.newArrayList((Iterable)hostService.getAddressBindings());
        Collections.sort(addresses, Comparators.ADDRESSES_COMPARATOR);
        for (PortAddresses pa : addresses) {
            this.print(FORMAT, pa.connectPoint().deviceId(), pa.connectPoint().port(), this.printIpAddresses(pa.ipAddresses()), pa.mac(), pa.vlan());
        }
    }

    private String printIpAddresses(Set<InterfaceIpAddress> addresses) {
        StringBuilder output = new StringBuilder("[");
        for (InterfaceIpAddress address : addresses) {
            output.append(address.ipAddress().toString());
            output.append("/");
            output.append(address.subnetAddress().prefixLength());
            output.append(", ");
        }
        output.delete(output.length() - 2, output.length());
        output.append("]");
        return output.toString();
    }
}

