/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.store.service.StorageAdminService;

@Command(scope="onos", name="counters", description="Lists information about atomic counters in the system")
public class CountersListCommand
extends AbstractShellCommand {
    private static final String FMT = "name=%s value=%d";

    private void displayCounters(Map<String, Long> counters) {
        counters.forEach((name, value) -> this.print(FMT, name, value));
    }

    private JsonNode json(Map<String, Long> counters) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode jsonCounters = mapper.createArrayNode();
        counters.forEach((name, value) -> {
            ObjectNode jsonCounter = mapper.createObjectNode();
            jsonCounter.put("name", name).put("value", value);
            jsonCounters.add((JsonNode)jsonCounter);
        });
        return jsonCounters;
    }

    private JsonNode jsonAllCounters(Map<String, Long> partitionedDbCounters, Map<String, Long> inMemoryDbCounters) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode jsonCounters = mapper.createArrayNode();
        ObjectNode jsonPartitionedDatabaseCounters = mapper.createObjectNode();
        jsonPartitionedDatabaseCounters.put("partitionedDatabaseCounters", this.json(partitionedDbCounters));
        jsonCounters.add((JsonNode)jsonPartitionedDatabaseCounters);
        ObjectNode jsonInMemoryDatabseCounters = mapper.createObjectNode();
        jsonInMemoryDatabseCounters.put("inMemoryDatabaseCounters", this.json(inMemoryDbCounters));
        jsonCounters.add((JsonNode)jsonInMemoryDatabseCounters);
        return jsonCounters;
    }

    @Override
    protected void execute() {
        StorageAdminService storageAdminService = CountersListCommand.get(StorageAdminService.class);
        Map partitionedDatabaseCounters = storageAdminService.getPartitionedDatabaseCounters();
        Map inMemoryDatabaseCounters = storageAdminService.getInMemoryDatabaseCounters();
        if (this.outputJson()) {
            this.print("%s", this.jsonAllCounters(partitionedDatabaseCounters, inMemoryDatabaseCounters));
        } else {
            this.print("Partitioned database counters:", new Object[0]);
            this.displayCounters(partitionedDatabaseCounters);
            this.print("In-memory database counters:", new Object[0]);
            this.displayCounters(inMemoryDatabaseCounters);
        }
    }
}

