/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Set;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverAdminService;

@Command(scope="onos", name="drivers", description="Lists device drivers")
public class DriversListCommand
extends AbstractShellCommand {
    private static final String FMT = "driver=%s, extends=%s, mfr=%s, hw=%s, sw=%s";
    private static final String FMT_B = "   %s via %s";
    private static final String FMT_P = "   %s=%s";
    @Argument(index=0, name="driverName", description="Driver name", required=false, multiValued=false)
    String driverName = null;

    @Override
    protected void execute() {
        DriverAdminService service = DriversListCommand.get(DriverAdminService.class);
        if (this.driverName != null) {
            this.printDriver(service.getDriver(this.driverName));
        } else if (this.outputJson()) {
            this.json(service.getDrivers());
        } else {
            service.getDrivers().forEach(this::printDriver);
        }
    }

    private void json(Driver driver) {
        this.print("%s", this.jsonForEntity(driver, Driver.class));
    }

    private void json(Set<Driver> drivers) {
        ArrayNode result = this.mapper().createArrayNode();
        drivers.forEach(driver -> result.add((JsonNode)this.jsonForEntity(driver, Driver.class)));
        this.print("%s", result.toString());
    }

    private void printDriver(Driver driver) {
        if (this.outputJson()) {
            this.json(driver);
        } else {
            Driver parent = driver.parent();
            this.print(FMT, driver.name(), parent != null ? parent.name() : "none", driver.manufacturer(), driver.hwVersion(), driver.swVersion());
            driver.behaviours().forEach(b -> this.print(FMT_B, b.getCanonicalName(), driver.implementation(b).getCanonicalName()));
            driver.properties().forEach((k, v) -> this.print(FMT_P, k, v));
        }
    }
}

