/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.util.Tools;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;

@Command(scope="onos", name="leaders", description="Finds the leader for particular topic.")
public class LeaderCommand
extends AbstractShellCommand {
    private static final String FMT = "%-30s | %-15s | %-6s | %-10s |";
    private static final String FMT_C = "%-30s | %-15s | %-19s |";
    private boolean allTopics;
    private Pattern pattern;
    @Argument(index=0, name="topic", description="A leadership topic. Can be a regex", required=false, multiValued=false)
    String topicPattern = null;
    @Option(name="-c", aliases={"--candidates"}, description="List candidate Nodes for each topic's leadership race", required=false, multiValued=false)
    private boolean showCandidates = false;
    private Comparator<Leadership> leadershipComparator = (e1, e2) -> {
        if (e1.leader() == null && e2.leader() == null) {
            return 0;
        }
        if (e1.leader() == null) {
            return 1;
        }
        if (e2.leader() == null) {
            return -1;
        }
        return e1.leader().toString().compareTo(e2.leader().toString());
    };

    private void displayLeaders(Map<String, Leadership> leaderBoard) {
        this.print("------------------------------------------------------------------------", new Object[0]);
        this.print(FMT, "Topic", "Leader", "Epoch", "Elected");
        this.print("------------------------------------------------------------------------", new Object[0]);
        leaderBoard.values().stream().filter(l -> this.allTopics || this.pattern.matcher(l.topic()).matches()).sorted(this.leadershipComparator).forEach(l -> this.print(FMT, l.topic(), l.leader(), l.epoch(), Tools.timeAgo((long)l.electedTime())));
        this.print("------------------------------------------------------------------------", new Object[0]);
    }

    private void displayCandidates(Map<String, Leadership> leaderBoard, Map<String, List<NodeId>> candidates) {
        this.print("------------------------------------------------------------------------", new Object[0]);
        this.print(FMT_C, "Topic", "Leader", "Candidates");
        this.print("------------------------------------------------------------------------", new Object[0]);
        candidates.entrySet().stream().filter(es -> this.allTopics || this.pattern.matcher((CharSequence)es.getKey()).matches()).forEach(es -> {
            List list = (List)es.getValue();
            if (list == null || list.isEmpty()) {
                return;
            }
            Leadership l = (Leadership)leaderBoard.get(es.getKey());
            this.print(FMT_C, es.getKey(), l == null ? "null" : l.leader(), ((NodeId)list.get(0)).toString());
            list.subList(1, list.size()).forEach(n -> this.print(FMT_C, " ", " ", n));
            this.print(FMT_C, " ", " ", " ");
        });
        this.print("------------------------------------------------------------------------", new Object[0]);
    }

    private JsonNode json(Map<String, Leadership> leaderBoard) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        leaderBoard.values().stream().sorted(this.leadershipComparator).forEach(l -> result.add((JsonNode)mapper.createObjectNode().put("topic", l.topic()).put("leader", l.leader().toString()).put("candidates", l.candidates().toString()).put("epoch", l.epoch()).put("electedTime", Tools.timeAgo((long)l.electedTime()))));
        return result;
    }

    private JsonNode json(Map<String, Leadership> leaderBoard, Map<String, List<NodeId>> candidateBoard) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        candidateBoard.entrySet().stream().forEach(es -> {
            Leadership l = (Leadership)leaderBoard.get(es.getKey());
            result.add((JsonNode)mapper.createObjectNode().put("topic", (String)es.getKey()).put("leader", l == null ? "none" : l.leader().toString()).put("candidates", ((List)es.getValue()).toString()));
        });
        return result;
    }

    @Override
    protected void execute() {
        LeadershipService leaderService = LeaderCommand.get(LeadershipService.class);
        Map leaderBoard = leaderService.getLeaderBoard();
        if (this.topicPattern == null) {
            this.allTopics = true;
        } else {
            this.allTopics = false;
            this.pattern = Pattern.compile(this.topicPattern);
        }
        if (this.showCandidates) {
            Map candidates = leaderService.getCandidates();
            if (this.outputJson()) {
                this.print("%s", this.json(leaderBoard, candidates));
            } else {
                this.displayCandidates(leaderBoard, candidates);
            }
        } else if (this.outputJson()) {
            this.print("%s", this.json(leaderBoard));
        } else {
            this.displayLeaders(leaderBoard);
        }
    }
}

