/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.net.ClustersListCommand;
import org.onosproject.net.Device;
import org.onosproject.net.Host;
import org.onosproject.net.device.DeviceAdminService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.host.HostAdminService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentState;

@Command(scope="onos", name="wipe-out", description="Wipes-out the entire network information base, i.e. devices, links, hosts")
public class WipeOutCommand
extends ClustersListCommand {
    private static final String PLEASE = "please";
    @Argument(index=0, name="please", description="Confirmation phrase", required=false, multiValued=false)
    String please = null;

    @Override
    protected void execute() {
        if (this.please == null || !this.please.equals(PLEASE)) {
            this.print("I'm afraid I can't do that!\nSay: %s", PLEASE);
            return;
        }
        this.print("Wiping devices", new Object[0]);
        DeviceAdminService deviceAdminService = WipeOutCommand.get(DeviceAdminService.class);
        DeviceService deviceService = WipeOutCommand.get(DeviceService.class);
        for (Device device : deviceService.getDevices()) {
            deviceAdminService.removeDevice(device.id());
        }
        this.print("Wiping hosts", new Object[0]);
        HostAdminService hostAdminService = WipeOutCommand.get(HostAdminService.class);
        HostService hostService = WipeOutCommand.get(HostService.class);
        for (Host host : hostService.getHosts()) {
            hostAdminService.removeHost(host.id());
        }
        this.print("Wiping intents", new Object[0]);
        IntentService intentService = WipeOutCommand.get(IntentService.class);
        for (Intent intent : intentService.getIntents()) {
            if (intentService.getIntentState(intent.key()) != IntentState.INSTALLED) continue;
            intentService.withdraw(intent);
        }
    }
}

