/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.cfg;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.SubjectFactory;

@Command(scope="onos", name="netcfg", description="Manages network configuration")
public class NetworkConfigCommand
extends AbstractShellCommand {
    @Argument(index=0, name="subjectKey", description="Subject key", required=false, multiValued=false)
    String subjectKey = null;
    @Argument(index=1, name="subject", description="Subject", required=false, multiValued=false)
    String subject = null;
    @Argument(index=2, name="configKey", description="Config key", required=false, multiValued=false)
    String configKey = null;
    private final ObjectMapper mapper = new ObjectMapper();
    private NetworkConfigService service;

    @Override
    protected void execute() {
        this.service = NetworkConfigCommand.get(NetworkConfigService.class);
        ObjectNode root = new ObjectMapper().createObjectNode();
        if (Strings.isNullOrEmpty((String)this.subjectKey)) {
            this.addAll(root);
        } else {
            SubjectFactory subjectFactory = this.service.getSubjectFactory(this.subjectKey);
            if (Strings.isNullOrEmpty((String)this.subject)) {
                this.addSubjectClass(root, subjectFactory);
            } else {
                Object s = subjectFactory.createSubject(this.subject);
                if (Strings.isNullOrEmpty((String)this.configKey)) {
                    this.addSubject(root, s);
                } else {
                    root = this.getSubjectConfig(this.getConfig(s, this.subjectKey, this.configKey));
                }
            }
        }
        this.print("%s", root.toString());
    }

    private void addAll(ObjectNode root) {
        this.service.getSubjectClasses().forEach(sc -> {
            SubjectFactory sf = this.service.getSubjectFactory(sc);
            this.addSubjectClass(this.newObject(root, sf.subjectKey()), sf);
        });
    }

    private void addSubjectClass(ObjectNode root, SubjectFactory sf) {
        this.service.getSubjects(sf.subjectClass()).forEach(s -> this.addSubject(this.newObject(root, s.toString()), s));
    }

    private void addSubject(ObjectNode root, Object s) {
        this.service.getConfigs(s).forEach(c -> root.set(c.key(), c.node()));
    }

    private JsonNode getSubjectConfig(Config config) {
        return config != null ? config.node() : null;
    }

    private Config getConfig(Object s, String subjectKey, String ck) {
        Class configClass = this.service.getConfigClass(subjectKey, ck);
        return configClass != null ? this.service.getConfig(s, configClass) : null;
    }

    private ObjectNode newObject(ObjectNode parent, String key) {
        ObjectNode node = this.mapper.createObjectNode();
        parent.set(key, (JsonNode)node);
        return node;
    }
}

