/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.Comparators;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceService;

@Command(scope="onos", name="interfaces", description="Lists all configured interfaces.")
public class InterfacesListCommand
extends AbstractShellCommand {
    private static final String FORMAT = "port=%s/%s, ips=%s, mac=%s, vlan=%s";

    @Override
    protected void execute() {
        InterfaceService interfaceService = InterfacesListCommand.get(InterfaceService.class);
        ArrayList interfaces = Lists.newArrayList((Iterable)interfaceService.getInterfaces());
        Collections.sort(interfaces, Comparators.INTERFACES_COMPARATOR);
        for (Interface intf : interfaces) {
            this.print(FORMAT, intf.connectPoint().deviceId(), intf.connectPoint().port(), intf.ipAddresses(), intf.mac(), intf.vlan());
        }
    }
}

