/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.Collection;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.resource.label.DefaultLabelResource;
import org.onosproject.incubator.net.resource.label.LabelResourceService;
import org.onosproject.net.DeviceId;

@Command(scope="onos", name="label-apply", description="Apply label resource from device pool by specific device id")
public class LabelApplyCommand
extends AbstractShellCommand {
    @Argument(index=0, name="deviceId", description="Device identity", required=true, multiValued=false)
    String deviceId = null;
    @Argument(index=1, name="applyNum", description="Applying number means how many labels applications want to use.", required=true, multiValued=false)
    String applyNum = null;
    private static final String FMT = "deviceid=%s, labelresourceid=%s";

    @Override
    protected void execute() {
        LabelResourceService lrs = LabelApplyCommand.get(LabelResourceService.class);
        Collection result = lrs.applyFromDevicePool(DeviceId.deviceId((String)this.deviceId), Long.parseLong(this.applyNum));
        if (result.size() > 0) {
            for (DefaultLabelResource defaultLabelResource : result) {
                this.print(FMT, defaultLabelResource.deviceId().toString(), defaultLabelResource.labelResourceId().toString());
            }
        }
    }
}

