/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Path;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.resource.link.DefaultLinkResourceRequest;
import org.onosproject.net.resource.link.LinkResourceAllocations;
import org.onosproject.net.resource.link.LinkResourceRequest;
import org.onosproject.net.resource.link.LinkResourceService;
import org.onosproject.net.topology.PathService;

@Command(scope="onos", name="resource-request", description="request or remove resources")
public class LinkResourceTestCommand
extends AbstractShellCommand {
    @Option(name="-m", aliases={"--mpls"}, description="MPLS resource", required=false, multiValued=false)
    private boolean isMPLS = false;
    @Option(name="-o", aliases={"--optical"}, description="Optical resource", required=false, multiValued=false)
    private boolean isOptical = false;
    @Option(name="-d", aliases={"--delete"}, description="Delete resource by intent ID", required=false, multiValued=false)
    private boolean remove = false;
    @Argument(index=0, name="srcString", description="Link source", required=true, multiValued=false)
    String srcString = null;
    @Argument(index=1, name="dstString", description="Link destination", required=true, multiValued=false)
    String dstString = null;
    @Argument(index=2, name="id", description="Identifier", required=true, multiValued=false)
    int id;
    private LinkResourceService resService;
    private PathService pathService;
    private static final int BANDWIDTH = 1000000;

    @Override
    protected void execute() {
        this.resService = LinkResourceTestCommand.get(LinkResourceService.class);
        this.pathService = LinkResourceTestCommand.get(PathService.class);
        DeviceId src = DeviceId.deviceId((String)this.getDeviceId(this.srcString));
        DeviceId dst = DeviceId.deviceId((String)this.getDeviceId(this.dstString));
        IntentId intId = IntentId.valueOf((long)this.id);
        Set paths = this.pathService.getPaths((ElementId)src, (ElementId)dst);
        if (paths == null || paths.isEmpty()) {
            this.print("No path between %s and %s", this.srcString, this.dstString);
            return;
        }
        if (this.remove) {
            LinkResourceAllocations lra = this.resService.getAllocations(intId);
            this.resService.releaseResources(lra);
            return;
        }
        for (Path p : paths) {
            LinkResourceRequest.Builder request;
            block7: {
                List links = p.links();
                request = null;
                if (this.isMPLS) {
                    ArrayList nlinks = Lists.newArrayList();
                    try {
                        nlinks.addAll(links.subList(1, links.size() - 2));
                        request = DefaultLinkResourceRequest.builder((IntentId)intId, (Collection)nlinks).addMplsRequest();
                        break block7;
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.log.warn("could not allocate MPLS path", (Throwable)e);
                        continue;
                    }
                }
                request = this.isOptical ? DefaultLinkResourceRequest.builder((IntentId)intId, (Collection)links).addLambdaRequest() : DefaultLinkResourceRequest.builder((IntentId)intId, (Collection)links).addBandwidthRequest(1000000.0);
            }
            if (request != null) {
                LinkResourceRequest lrr = request.build();
                LinkResourceAllocations lra = this.resService.requestResources(lrr);
                if (lra != null) break;
                this.print("Allocated:\n%s", lra);
                continue;
            }
            this.log.info("nothing to request");
        }
    }

    public String getDeviceId(String deviceString) {
        int slash = deviceString.indexOf(47);
        if (slash <= 0) {
            return "";
        }
        return deviceString.substring(0, slash);
    }
}

