/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.util.Tools;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.store.service.StorageAdminService;
import org.onosproject.store.service.Transaction;

@Command(scope="onos", name="transactions", description="Utility for viewing and redriving database transactions")
public class TransactionsCommand
extends AbstractShellCommand {
    @Option(name="-r", aliases={"--redrive"}, description="Redrive stuck transactions while removing those that are done", required=false, multiValued=false)
    private boolean redrive = false;
    private static final String FMT = "%-20s %-15s %-10s";

    private void displayTransactions(Collection<Transaction> transactions) {
        this.print("---------------------------------------------", new Object[0]);
        this.print(FMT, "Id", "State", "Updated");
        this.print("---------------------------------------------", new Object[0]);
        transactions.forEach(txn -> this.print(FMT, txn.id(), txn.state(), Tools.timeAgo((long)txn.lastUpdated())));
        if (transactions.size() > 0) {
            this.print("---------------------------------------------", new Object[0]);
        }
    }

    private JsonNode json(Collection<Transaction> transactions) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode txns = mapper.createArrayNode();
        transactions.stream().forEach(txn -> {
            ObjectNode txnNode = mapper.createObjectNode();
            txnNode.put("id", txn.id()).put("state", txn.state().toString()).put("lastUpdated", txn.lastUpdated());
            txns.add((JsonNode)txnNode);
        });
        return txns;
    }

    @Override
    protected void execute() {
        StorageAdminService storageAdminService = TransactionsCommand.get(StorageAdminService.class);
        if (this.redrive) {
            storageAdminService.redriveTransactions();
            return;
        }
        Collection transactions = storageAdminService.getTransactions();
        if (this.outputJson()) {
            this.print("%s", this.json(transactions));
        } else {
            this.displayTransactions(transactions);
        }
    }
}

