/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.net.ConnectivityIntentCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.OchPort;
import org.onosproject.net.OduCltPort;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.Port;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.OpticalCircuitIntent;
import org.onosproject.net.intent.OpticalConnectivityIntent;

@Command(scope="onos", name="add-optical-intent", description="Installs optical connectivity intent")
public class AddOpticalIntentCommand
extends ConnectivityIntentCommand {
    @Argument(index=0, name="ingressDevice", description="Ingress Device/Port Description", required=true, multiValued=false)
    String ingressDeviceString = "";
    @Argument(index=1, name="egressDevice", description="Egress Device/Port Description", required=true, multiValued=false)
    String egressDeviceString = "";
    @Option(name="-b", aliases={"--bidirectional"}, description="If this argument is passed the optical link created will be bidirectional, else the link will be unidirectional.", required=false, multiValued=false)
    private boolean bidirectional = false;

    private ConnectPoint createConnectPoint(String devicePortString) {
        String[] splitted = devicePortString.split("/");
        Preconditions.checkArgument((splitted.length == 2 ? 1 : 0) != 0, (Object)"Connect point must be in \"deviceUri/portNumber\" format");
        DeviceId deviceId = DeviceId.deviceId((String)splitted[0]);
        DeviceService deviceService = AddOpticalIntentCommand.get(DeviceService.class);
        List ports = deviceService.getPorts(deviceId);
        for (Port port : ports) {
            if (!splitted[1].equals(port.number().name())) continue;
            return new ConnectPoint((ElementId)deviceId, port.number());
        }
        return null;
    }

    @Override
    protected void execute() {
        OpticalCircuitIntent intent;
        IntentService service = AddOpticalIntentCommand.get(IntentService.class);
        ConnectPoint ingress = this.createConnectPoint(this.ingressDeviceString);
        ConnectPoint egress = this.createConnectPoint(this.egressDeviceString);
        if (ingress == null || egress == null) {
            this.print("Invalid endpoint(s); could not create optical intent", new Object[0]);
            return;
        }
        DeviceService deviceService = AddOpticalIntentCommand.get(DeviceService.class);
        Port srcPort = deviceService.getPort(ingress.deviceId(), ingress.port());
        Port dstPort = deviceService.getPort(egress.deviceId(), egress.port());
        if (srcPort instanceof OduCltPort && dstPort instanceof OduCltPort) {
            intent = OpticalCircuitIntent.builder().appId(this.appId()).key(this.key()).src(ingress).dst(egress).signalType(OduCltPort.SignalType.CLT_10GBE).bidirectional(this.bidirectional).build();
        } else if (srcPort instanceof OchPort && dstPort instanceof OchPort) {
            intent = OpticalConnectivityIntent.builder().appId(this.appId()).key(this.key()).src(ingress).dst(egress).signalType(OduSignalType.ODU4).bidirectional(this.bidirectional).build();
        } else {
            this.print("Unable to create optical intent between connect points {} and {}", ingress, egress);
            return;
        }
        service.submit((Intent)intent);
        this.print("Optical intent submitted:\n%s", intent.toString());
    }
}

