/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.stream.StreamSupport;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.OchSignal;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.newresource.ResourceAllocation;
import org.onosproject.net.newresource.ResourcePath;
import org.onosproject.net.newresource.ResourceService;

@Command(scope="onos", name="allocations", description="Lists allocated resources")
public class AllocationsCommand
extends AbstractShellCommand {
    @Option(name="-l", aliases={"--lambda"}, description="Lambda Resource", required=false, multiValued=false)
    private boolean lambda = true;
    @Argument(index=0, name="deviceIdString", description="Device ID", required=false, multiValued=false)
    String deviceIdStr = null;
    @Argument(index=1, name="portNumberString", description="PortNumber", required=false, multiValued=false)
    String portNumberStr = null;
    private DeviceService deviceService;
    private ResourceService resourceService;

    @Override
    protected void execute() {
        this.deviceService = AllocationsCommand.get(DeviceService.class);
        this.resourceService = AllocationsCommand.get(ResourceService.class);
        if (this.deviceIdStr != null && this.portNumberStr != null) {
            DeviceId deviceId = DeviceId.deviceId((String)this.deviceIdStr);
            PortNumber portNumber = PortNumber.fromString((String)this.portNumberStr);
            this.printAllocation(deviceId, portNumber, 0);
        } else if (this.deviceIdStr != null) {
            DeviceId deviceId = DeviceId.deviceId((String)this.deviceIdStr);
            this.printAllocation(deviceId, 0);
        } else {
            this.printAllocation();
        }
    }

    private void printAllocation() {
        this.print("ROOT", new Object[0]);
        StreamSupport.stream(this.deviceService.getAvailableDevices().spliterator(), false).map(Device::id).forEach(did -> this.printAllocation((DeviceId)did, 1));
    }

    private void printAllocation(DeviceId did, int level) {
        this.print("%s%s", Strings.repeat((String)" ", (int)level), did);
        StreamSupport.stream(this.deviceService.getPorts(did).spliterator(), false).map(Port::number).forEach(num -> this.printAllocation(did, (PortNumber)num, level + 1));
    }

    private void printAllocation(DeviceId did, PortNumber num, int level) {
        if (level == 0) {
            this.print("%s", did);
        }
        this.print("%s%s", Strings.repeat((String)" ", (int)level), AllocationsCommand.asVerboseString(num));
        ResourcePath path = ResourcePath.discrete((DeviceId)did, (PortNumber)num, (Object[])new Object[0]);
        if (this.lambda) {
            Collection allocations = this.resourceService.getResourceAllocations(path, OchSignal.class);
            for (ResourceAllocation a : allocations) {
                this.print("%s%s allocated by %s", Strings.repeat((String)" ", (int)(level + 1)), a.resource().last(), AllocationsCommand.asVerboseString(a.consumer()));
            }
        }
    }

    private static String asVerboseString(Object obj) {
        String name = obj.getClass().getSimpleName();
        String toString = String.valueOf(obj);
        if (toString.startsWith(name)) {
            return toString;
        }
        return String.format("%s:%s", name, toString);
    }
}

