/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.util.Frequency;
import org.onosproject.cli.Comparators;
import org.onosproject.cli.net.DevicesListCommand;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.OchPort;
import org.onosproject.net.OduCltPort;
import org.onosproject.net.OmsPort;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;

@Command(scope="onos", name="ports", description="Lists all ports or all ports of a device")
public class DevicePortsListCommand
extends DevicesListCommand {
    private static final String FMT = "  port=%s, state=%s, type=%s, speed=%s %s";
    private static final String FMT_OCH = "  port=%s, state=%s, type=%s, signalType=%s, isTunable=%s %s";
    private static final String FMT_ODUCLT = "  port=%s, state=%s, type=%s, signalType=%s %s";
    private static final String FMT_OMS = "  port=%s, state=%s, type=%s, Freqs= %s / %s / %s GHz, totalChannels=%s %s";
    @Option(name="-e", aliases={"--enabled"}, description="Show only enabled ports", required=false, multiValued=false)
    private boolean enabled = false;
    @Option(name="-d", aliases={"--disabled"}, description="Show only disabled ports", required=false, multiValued=false)
    private boolean disabled = false;
    @Argument(index=0, name="uri", description="Device ID", required=false, multiValued=false)
    String uri = null;

    @Override
    protected void execute() {
        DeviceService service = DevicePortsListCommand.get(DeviceService.class);
        if (this.uri == null) {
            if (this.outputJson()) {
                this.print("%s", this.jsonPorts(service, DevicePortsListCommand.getSortedDevices(service)));
            } else {
                for (Device device : DevicePortsListCommand.getSortedDevices(service)) {
                    this.printDevice(service, device);
                }
            }
        } else {
            Device device = service.getDevice(DeviceId.deviceId((String)this.uri));
            if (device == null) {
                this.error("No such device %s", this.uri);
            } else if (this.outputJson()) {
                this.print("%s", this.jsonPorts(service, new ObjectMapper(), device));
            } else {
                this.printDevice(service, device);
            }
        }
    }

    public JsonNode jsonPorts(DeviceService service, Iterable<Device> devices) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (Device device : devices) {
            result.add(this.jsonPorts(service, mapper, device));
        }
        return result;
    }

    public JsonNode jsonPorts(DeviceService service, ObjectMapper mapper, Device device) {
        ObjectNode result = mapper.createObjectNode();
        ArrayNode ports = mapper.createArrayNode();
        for (Port port : service.getPorts(device.id())) {
            if (!this.isIncluded(port)) continue;
            ports.add(mapper.createObjectNode().put("port", this.portName(port.number())).put("isEnabled", port.isEnabled()).put("type", port.type().toString().toLowerCase()).put("portSpeed", port.portSpeed()).set("annotations", (JsonNode)DevicePortsListCommand.annotations(mapper, port.annotations())));
        }
        result.set("device", (JsonNode)this.jsonForEntity(device, Device.class));
        result.set("ports", (JsonNode)ports);
        return result;
    }

    private String portName(PortNumber port) {
        return port.equals((Object)PortNumber.LOCAL) ? "local" : port.toString();
    }

    private boolean isIncluded(Port port) {
        return this.enabled && port.isEnabled() || this.disabled && !port.isEnabled() || !this.enabled && !this.disabled;
    }

    @Override
    protected void printDevice(DeviceService service, Device device) {
        super.printDevice(service, device);
        ArrayList ports = new ArrayList(service.getPorts(device.id()));
        Collections.sort(ports, Comparators.PORT_COMPARATOR);
        block5: for (Port port : ports) {
            if (!this.isIncluded(port)) continue;
            String portName = this.portName(port.number());
            String portIsEnabled = port.isEnabled() ? "enabled" : "disabled";
            String portType = port.type().toString().toLowerCase();
            String annotations = DevicePortsListCommand.annotations(port.annotations());
            switch (port.type()) {
                case OCH: {
                    this.print(FMT_OCH, portName, portIsEnabled, portType, ((OchPort)port).signalType().toString(), ((OchPort)port).isTunable() ? "yes" : "no", annotations);
                    continue block5;
                }
                case ODUCLT: {
                    this.print(FMT_ODUCLT, portName, portIsEnabled, portType, ((OduCltPort)port).signalType().toString(), annotations);
                    continue block5;
                }
                case OMS: {
                    this.print(FMT_OMS, portName, portIsEnabled, portType, ((OmsPort)port).minFrequency().asHz() / Frequency.ofGHz((double)1.0).asHz(), ((OmsPort)port).maxFrequency().asHz() / Frequency.ofGHz((double)1.0).asHz(), ((OmsPort)port).grid().asHz() / Frequency.ofGHz((double)1.0).asHz(), ((OmsPort)port).totalChannels(), annotations);
                    continue block5;
                }
            }
            this.print(FMT, portName, portIsEnabled, portType, port.portSpeed(), annotations);
        }
    }
}

