/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceAdminService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.host.InterfaceIpAddress;

@Command(scope="onos", name="add-interface", description="Adds a new configured interface")
public class InterfaceAddCommand
extends AbstractShellCommand {
    @Argument(index=0, name="port", description="Device port that the interface is associated with", required=true, multiValued=false)
    private String connectPoint = null;
    @Argument(index=1, name="name", description="Interface name", required=true, multiValued=false)
    private String name = null;
    @Option(name="-m", aliases={"--mac"}, description="MAC address of the interface", required=false, multiValued=false)
    private String mac = null;
    @Option(name="-i", aliases={"--ip"}, description="IP address configured on the interface\n(e.g. 10.0.1.1/24). Can be specified multiple times.", required=false, multiValued=true)
    private String[] ips = null;
    @Option(name="-v", aliases={"--vlan"}, description="VLAN configured on the interface", required=false, multiValued=false)
    private String vlan = null;

    @Override
    protected void execute() {
        InterfaceAdminService interfaceService = InterfaceAddCommand.get(InterfaceAdminService.class);
        HashSet ipAddresses = Sets.newHashSet();
        if (this.ips != null) {
            for (String strIp : this.ips) {
                ipAddresses.add(InterfaceIpAddress.valueOf((String)strIp));
            }
        }
        MacAddress macAddr = this.mac == null ? null : MacAddress.valueOf((String)this.mac);
        VlanId vlanId = this.vlan == null ? VlanId.NONE : VlanId.vlanId((short)Short.parseShort(this.vlan));
        Interface intf = new Interface(this.name, ConnectPoint.deviceConnectPoint((String)this.connectPoint), (Set)ipAddresses, macAddr, vlanId);
        interfaceService.add(intf);
        this.print("Interface added", new Object[0]);
    }
}

