/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.base.Strings;
import java.util.Collection;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.newresource.ResourcePath;
import org.onosproject.net.newresource.ResourceService;

@Command(scope="onos", name="resources", description="Lists available resources")
public class ResourcesCommand
extends AbstractShellCommand {
    @Argument(index=0, name="deviceIdString", description="Device ID", required=false, multiValued=false)
    String deviceIdStr = null;
    @Argument(index=1, name="portNumberString", description="PortNumber", required=false, multiValued=false)
    String portNumberStr = null;
    private ResourceService resourceService;

    @Override
    protected void execute() {
        this.resourceService = ResourcesCommand.get(ResourceService.class);
        if (this.deviceIdStr != null && this.portNumberStr != null) {
            DeviceId deviceId = DeviceId.deviceId((String)this.deviceIdStr);
            PortNumber portNumber = PortNumber.fromString((String)this.portNumberStr);
            this.printResource(ResourcePath.discrete((DeviceId)deviceId, (PortNumber)portNumber, (Object[])new Object[0]), 0);
        } else if (this.deviceIdStr != null) {
            DeviceId deviceId = DeviceId.deviceId((String)this.deviceIdStr);
            this.printResource(ResourcePath.discrete((DeviceId)deviceId), 0);
        } else {
            this.printResource((ResourcePath)ResourcePath.ROOT, 0);
        }
    }

    private void printResource(ResourcePath resource, int level) {
        if (resource.equals((Object)ResourcePath.ROOT)) {
            this.print("ROOT", new Object[0]);
        } else {
            String name = resource.last().getClass().getSimpleName();
            String toString = String.valueOf(resource.last());
            if (toString.startsWith(name)) {
                this.print("%s%s", Strings.repeat((String)" ", (int)level), toString);
            } else {
                this.print("%s%s:%s", Strings.repeat((String)" ", (int)level), name, toString);
            }
        }
        Collection resources = this.resourceService.getAvailableResources(resource);
        resources.forEach(r -> this.printResource((ResourcePath)r, level + 1));
    }
}

