/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.packet.VlanId;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.InterfaceConfig;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;

@Command(scope="onos", name="device-add-interface", description="Configures a device interface")
public class DeviceInterfaceAddCommand
extends AbstractShellCommand {
    private static final String CONFIG_VLAN_SUCCESS = "VLAN %s added on device %s interface %s.";
    private static final String CONFIG_VLAN_FAILURE = "Failed to add VLAN %s on device %s interface %s.";
    private static final String CONFIG_TRUNK_SUCCESS = "Trunk mode added for VLAN %s on device %s interface %s.";
    private static final String CONFIG_TRUNK_FAILURE = "Failed to add trunk mode for VLAN %s on device %s interface %s.";
    @Argument(index=0, name="uri", description="Device ID", required=true, multiValued=false)
    private String uri = null;
    @Argument(index=1, name="interface", description="Interface name", required=true, multiValued=false)
    private String portName = null;
    @Argument(index=2, name="vlan", description="VLAN ID", required=true, multiValued=false)
    private String vlanString = null;
    @Option(name="-t", aliases={"--trunk"}, description="Configure interface as trunk for VLAN", required=false, multiValued=false)
    private boolean trunkMode = false;

    @Override
    protected void execute() {
        DriverService service = DeviceInterfaceAddCommand.get(DriverService.class);
        DeviceId deviceId = DeviceId.deviceId((String)this.uri);
        DriverHandler h = service.createHandler(deviceId, new String[0]);
        InterfaceConfig interfaceConfig = (InterfaceConfig)h.behaviour(InterfaceConfig.class);
        VlanId vlanId = VlanId.vlanId((short)Short.parseShort(this.vlanString));
        if (this.trunkMode) {
            if (interfaceConfig.addTrunkInterface(deviceId, this.portName, vlanId)) {
                this.print(CONFIG_TRUNK_SUCCESS, vlanId, deviceId, this.portName);
            } else {
                this.print(CONFIG_TRUNK_FAILURE, vlanId, deviceId, this.portName);
            }
            return;
        }
        if (interfaceConfig.addInterfaceToVlan(deviceId, this.portName, vlanId)) {
            this.print(CONFIG_VLAN_SUCCESS, vlanId, deviceId, this.portName);
        } else {
            this.print(CONFIG_VLAN_FAILURE, vlanId, deviceId, this.portName);
        }
    }
}

