/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.statistic.Load;
import org.onosproject.net.statistic.StatisticService;

@Command(scope="onos", name="get-stats", description="Fetches stats for a connection point")
public class GetStatistics
extends AbstractShellCommand {
    @Argument(index=0, name="connectPoint", description="Device/Port Description", required=true, multiValued=false)
    String connectPoint = null;

    @Override
    protected void execute() {
        StatisticService service = GetStatistics.get(StatisticService.class);
        DeviceId ingressDeviceId = DeviceId.deviceId((String)this.getDeviceId(this.connectPoint));
        PortNumber ingressPortNumber = PortNumber.portNumber((String)this.getPortNumber(this.connectPoint));
        ConnectPoint cp = new ConnectPoint((ElementId)ingressDeviceId, ingressPortNumber);
        Load load = service.load(cp);
        this.print("Load on %s -> %s", cp, load);
    }

    private String getPortNumber(String deviceString) {
        int slash = deviceString.indexOf(47);
        if (slash <= 0) {
            return "";
        }
        return deviceString.substring(slash + 1, deviceString.length());
    }

    private String getDeviceId(String deviceString) {
        int slash = deviceString.indexOf(47);
        if (slash <= 0) {
            return "";
        }
        return deviceString.substring(0, slash);
    }
}

