/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Ordering;
import java.util.List;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.store.service.PartitionInfo;
import org.onosproject.store.service.StorageAdminService;

@Command(scope="onos", name="partitions", description="Lists information about partitions in the system")
public class PartitionsListCommand
extends AbstractShellCommand {
    private static final String FMT = "%-20s %8s %25s %s";

    private void displayPartitions(List<PartitionInfo> partitionInfo) {
        if (partitionInfo.isEmpty()) {
            return;
        }
        this.print("----------------------------------------------------------", new Object[0]);
        this.print(FMT, "Name", "Term", "Members", "");
        this.print("----------------------------------------------------------", new Object[0]);
        for (PartitionInfo info : partitionInfo) {
            boolean first = true;
            for (String member : Ordering.natural().sortedCopy((Iterable)info.members())) {
                if (first) {
                    this.print(FMT, info.name(), info.term(), member, member.equals(info.leader()) ? "*" : "");
                    first = false;
                    continue;
                }
                this.print(FMT, "", "", member, member.equals(info.leader()) ? "*" : "");
            }
            if (first) continue;
            this.print("----------------------------------------------------------", new Object[0]);
        }
    }

    private JsonNode json(List<PartitionInfo> partitionInfo) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode partitions = mapper.createArrayNode();
        partitionInfo.stream().forEach(info -> {
            ObjectNode partition = mapper.createObjectNode();
            ArrayNode members = partition.putArray("members");
            info.members().stream().forEach(arg_0 -> ((ArrayNode)members).add(arg_0));
            partition.put("name", info.name()).put("term", info.term()).put("leader", info.leader());
            partitions.add((JsonNode)partition);
        });
        return partitions;
    }

    @Override
    protected void execute() {
        StorageAdminService storageAdminService = PartitionsListCommand.get(StorageAdminService.class);
        List partitionInfo = storageAdminService.getPartitionInfo();
        if (this.outputJson()) {
            this.print("%s", this.json(partitionInfo));
        } else {
            this.displayPartitions(partitionInfo);
        }
    }
}

