/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.karaf.shell.console.completer.ArgumentCompleter;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onosproject.cli.AbstractChoicesCompleter;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;

public class PortNumberCompleter
extends AbstractChoicesCompleter {
    @Override
    protected List<String> choices() {
        ArgumentCompleter.ArgumentList args = this.getArgumentList();
        Preconditions.checkArgument((args.getCursorArgumentIndex() >= 1 ? 1 : 0) != 0, (Object)"Expects DeviceId as previous argument");
        String deviceIdStr = args.getArguments()[args.getCursorArgumentIndex() - 1];
        DeviceId deviceId = DeviceId.deviceId((String)deviceIdStr);
        DeviceService deviceService = (DeviceService)DefaultServiceDirectory.getService(DeviceService.class);
        return StreamSupport.stream(deviceService.getPorts(deviceId).spliterator(), false).map(port -> port.number().toString()).collect(Collectors.toList());
    }
}

